# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAssociationsResult',
    'AwaitableGetAssociationsResult',
    'get_associations',
    'get_associations_output',
]

@pulumi.output_type
class GetAssociationsResult:
    """
    A collection of values returned by getAssociations.
    """
    def __init__(__self__, associated_resource_id=None, association_collections=None, association_id=None, association_type=None, certificates_resource_id=None, compartment_id=None, filters=None, id=None, name=None):
        if associated_resource_id and not isinstance(associated_resource_id, str):
            raise TypeError("Expected argument 'associated_resource_id' to be a str")
        pulumi.set(__self__, "associated_resource_id", associated_resource_id)
        if association_collections and not isinstance(association_collections, list):
            raise TypeError("Expected argument 'association_collections' to be a list")
        pulumi.set(__self__, "association_collections", association_collections)
        if association_id and not isinstance(association_id, str):
            raise TypeError("Expected argument 'association_id' to be a str")
        pulumi.set(__self__, "association_id", association_id)
        if association_type and not isinstance(association_type, str):
            raise TypeError("Expected argument 'association_type' to be a str")
        pulumi.set(__self__, "association_type", association_type)
        if certificates_resource_id and not isinstance(certificates_resource_id, str):
            raise TypeError("Expected argument 'certificates_resource_id' to be a str")
        pulumi.set(__self__, "certificates_resource_id", certificates_resource_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="associatedResourceId")
    def associated_resource_id(self) -> Optional[str]:
        """
        The OCID of the associated resource.
        """
        return pulumi.get(self, "associated_resource_id")

    @property
    @pulumi.getter(name="associationCollections")
    def association_collections(self) -> Sequence['outputs.GetAssociationsAssociationCollectionResult']:
        """
        The list of association_collection.
        """
        return pulumi.get(self, "association_collections")

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[str]:
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> Optional[str]:
        """
        Type of the association.
        """
        return pulumi.get(self, "association_type")

    @property
    @pulumi.getter(name="certificatesResourceId")
    def certificates_resource_id(self) -> Optional[str]:
        """
        The OCID of the certificate-related resource associated with another Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "certificates_resource_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The compartment OCID of the association, which is strongly tied to the compartment OCID of the certificate-related resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAssociationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A user-friendly name generated by the service for the association, expressed in a format that follows the pattern: [certificatesResourceEntityType]-[associatedResourceEntityType]-UUID.
        """
        return pulumi.get(self, "name")


class AwaitableGetAssociationsResult(GetAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssociationsResult(
            associated_resource_id=self.associated_resource_id,
            association_collections=self.association_collections,
            association_id=self.association_id,
            association_type=self.association_type,
            certificates_resource_id=self.certificates_resource_id,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name)


def get_associations(associated_resource_id: Optional[str] = None,
                     association_id: Optional[str] = None,
                     association_type: Optional[str] = None,
                     certificates_resource_id: Optional[str] = None,
                     compartment_id: Optional[str] = None,
                     filters: Optional[Sequence[pulumi.InputType['GetAssociationsFilterArgs']]] = None,
                     name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssociationsResult:
    """
    This data source provides the list of Associations in Oracle Cloud Infrastructure Certificates Management service.

    Lists all associations that match the query parameters.
    Optionally, you can use the parameter `FilterByAssociationIdQueryParam` to limit the result set to a single item that matches the specified association.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_associations = oci.CertificatesManagement.get_associations(associated_resource_id=test_associated_resource["id"],
        association_id=test_association["id"],
        association_type=association_association_type,
        certificates_resource_id=test_certificates_resource["id"],
        compartment_id=compartment_id,
        name=association_name)
    ```


    :param str associated_resource_id: A filter that returns only resources that match the given OCID of an associated Oracle Cloud Infrastructure resource.
    :param str association_id: The OCID of the association. If the parameter is set to null, the service lists all associations.
    :param str association_type: Type of associations to list. If the parameter is set to null, the service lists all types of associations.
    :param str certificates_resource_id: A filter that returns only resources that match the given OCID of a certificate-related resource.
    :param str compartment_id: A filter that returns only resources that match the given compartment OCID.
    :param str name: A filter that returns only resources that match the specified name.
    """
    __args__ = dict()
    __args__['associatedResourceId'] = associated_resource_id
    __args__['associationId'] = association_id
    __args__['associationType'] = association_type
    __args__['certificatesResourceId'] = certificates_resource_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CertificatesManagement/getAssociations:getAssociations', __args__, opts=opts, typ=GetAssociationsResult).value

    return AwaitableGetAssociationsResult(
        associated_resource_id=pulumi.get(__ret__, 'associated_resource_id'),
        association_collections=pulumi.get(__ret__, 'association_collections'),
        association_id=pulumi.get(__ret__, 'association_id'),
        association_type=pulumi.get(__ret__, 'association_type'),
        certificates_resource_id=pulumi.get(__ret__, 'certificates_resource_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_associations)
def get_associations_output(associated_resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                            association_id: Optional[pulumi.Input[Optional[str]]] = None,
                            association_type: Optional[pulumi.Input[Optional[str]]] = None,
                            certificates_resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                            compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAssociationsFilterArgs']]]]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAssociationsResult]:
    """
    This data source provides the list of Associations in Oracle Cloud Infrastructure Certificates Management service.

    Lists all associations that match the query parameters.
    Optionally, you can use the parameter `FilterByAssociationIdQueryParam` to limit the result set to a single item that matches the specified association.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_associations = oci.CertificatesManagement.get_associations(associated_resource_id=test_associated_resource["id"],
        association_id=test_association["id"],
        association_type=association_association_type,
        certificates_resource_id=test_certificates_resource["id"],
        compartment_id=compartment_id,
        name=association_name)
    ```


    :param str associated_resource_id: A filter that returns only resources that match the given OCID of an associated Oracle Cloud Infrastructure resource.
    :param str association_id: The OCID of the association. If the parameter is set to null, the service lists all associations.
    :param str association_type: Type of associations to list. If the parameter is set to null, the service lists all types of associations.
    :param str certificates_resource_id: A filter that returns only resources that match the given OCID of a certificate-related resource.
    :param str compartment_id: A filter that returns only resources that match the given compartment OCID.
    :param str name: A filter that returns only resources that match the specified name.
    """
    ...
