# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetInstanceMaintenanceEventResult',
    'AwaitableGetInstanceMaintenanceEventResult',
    'get_instance_maintenance_event',
    'get_instance_maintenance_event_output',
]

@pulumi.output_type
class GetInstanceMaintenanceEventResult:
    """
    A collection of values returned by getInstanceMaintenanceEvent.
    """
    def __init__(__self__, additional_details=None, alternative_resolution_action=None, alternative_resolution_actions=None, can_delete_local_storage=None, can_reschedule=None, compartment_id=None, correlation_token=None, created_by=None, defined_tags=None, description=None, display_name=None, estimated_duration=None, freeform_tags=None, id=None, instance_action=None, instance_id=None, instance_maintenance_event_id=None, maintenance_category=None, maintenance_reason=None, start_window_duration=None, state=None, time_created=None, time_finished=None, time_hard_due_date=None, time_started=None, time_window_start=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if alternative_resolution_action and not isinstance(alternative_resolution_action, str):
            raise TypeError("Expected argument 'alternative_resolution_action' to be a str")
        pulumi.set(__self__, "alternative_resolution_action", alternative_resolution_action)
        if alternative_resolution_actions and not isinstance(alternative_resolution_actions, list):
            raise TypeError("Expected argument 'alternative_resolution_actions' to be a list")
        pulumi.set(__self__, "alternative_resolution_actions", alternative_resolution_actions)
        if can_delete_local_storage and not isinstance(can_delete_local_storage, bool):
            raise TypeError("Expected argument 'can_delete_local_storage' to be a bool")
        pulumi.set(__self__, "can_delete_local_storage", can_delete_local_storage)
        if can_reschedule and not isinstance(can_reschedule, bool):
            raise TypeError("Expected argument 'can_reschedule' to be a bool")
        pulumi.set(__self__, "can_reschedule", can_reschedule)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if correlation_token and not isinstance(correlation_token, str):
            raise TypeError("Expected argument 'correlation_token' to be a str")
        pulumi.set(__self__, "correlation_token", correlation_token)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if estimated_duration and not isinstance(estimated_duration, str):
            raise TypeError("Expected argument 'estimated_duration' to be a str")
        pulumi.set(__self__, "estimated_duration", estimated_duration)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_action and not isinstance(instance_action, str):
            raise TypeError("Expected argument 'instance_action' to be a str")
        pulumi.set(__self__, "instance_action", instance_action)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instance_maintenance_event_id and not isinstance(instance_maintenance_event_id, str):
            raise TypeError("Expected argument 'instance_maintenance_event_id' to be a str")
        pulumi.set(__self__, "instance_maintenance_event_id", instance_maintenance_event_id)
        if maintenance_category and not isinstance(maintenance_category, str):
            raise TypeError("Expected argument 'maintenance_category' to be a str")
        pulumi.set(__self__, "maintenance_category", maintenance_category)
        if maintenance_reason and not isinstance(maintenance_reason, str):
            raise TypeError("Expected argument 'maintenance_reason' to be a str")
        pulumi.set(__self__, "maintenance_reason", maintenance_reason)
        if start_window_duration and not isinstance(start_window_duration, str):
            raise TypeError("Expected argument 'start_window_duration' to be a str")
        pulumi.set(__self__, "start_window_duration", start_window_duration)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_hard_due_date and not isinstance(time_hard_due_date, str):
            raise TypeError("Expected argument 'time_hard_due_date' to be a str")
        pulumi.set(__self__, "time_hard_due_date", time_hard_due_date)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if time_window_start and not isinstance(time_window_start, str):
            raise TypeError("Expected argument 'time_window_start' to be a str")
        pulumi.set(__self__, "time_window_start", time_window_start)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, Any]:
        """
        Additional details of the maintenance in the form of json.
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="alternativeResolutionAction")
    def alternative_resolution_action(self) -> str:
        return pulumi.get(self, "alternative_resolution_action")

    @property
    @pulumi.getter(name="alternativeResolutionActions")
    def alternative_resolution_actions(self) -> Sequence[str]:
        """
        These are alternative actions to the requested instanceAction that can be taken to resolve the Maintenance.
        """
        return pulumi.get(self, "alternative_resolution_actions")

    @property
    @pulumi.getter(name="canDeleteLocalStorage")
    def can_delete_local_storage(self) -> bool:
        """
        For Instances that have local storage, this field is set to true when local storage will be deleted as a result of the Maintenance.
        """
        return pulumi.get(self, "can_delete_local_storage")

    @property
    @pulumi.getter(name="canReschedule")
    def can_reschedule(self) -> bool:
        """
        Indicates if this MaintenanceEvent is capable of being rescheduled up to the timeHardDueDate.
        """
        return pulumi.get(self, "can_reschedule")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the instance.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="correlationToken")
    def correlation_token(self) -> str:
        """
        A unique identifier that will group Instances that have a relationship with one another and must be scheduled together for the Maintenance to proceed. Any Instances that have a relationship with one another from a Maintenance perspective will have a matching correlationToken.
        """
        return pulumi.get(self, "correlation_token")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The creator of the maintenance event.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        It is the descriptive information about the maintenance taking place on the customer instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedDuration")
    def estimated_duration(self) -> str:
        """
        This is the estimated duration of the Maintenance, once the Maintenance has entered the STARTED state.
        """
        return pulumi.get(self, "estimated_duration")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance event.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceAction")
    def instance_action(self) -> str:
        """
        This is the action that will be performed on the Instance by Oracle Cloud Infrastructure when the Maintenance begins.
        """
        return pulumi.get(self, "instance_action")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The OCID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceMaintenanceEventId")
    def instance_maintenance_event_id(self) -> str:
        return pulumi.get(self, "instance_maintenance_event_id")

    @property
    @pulumi.getter(name="maintenanceCategory")
    def maintenance_category(self) -> str:
        """
        This indicates the priority and allowed actions for this Maintenance. Higher priority forms of Maintenance have tighter restrictions and may not be rescheduled, while lower priority/severity Maintenance can be rescheduled, deferred, or even cancelled. Please see the [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        """
        return pulumi.get(self, "maintenance_category")

    @property
    @pulumi.getter(name="maintenanceReason")
    def maintenance_reason(self) -> str:
        """
        This is the reason that Maintenance is being performed. See [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        """
        return pulumi.get(self, "maintenance_reason")

    @property
    @pulumi.getter(name="startWindowDuration")
    def start_window_duration(self) -> str:
        """
        The duration of the time window Maintenance is scheduled to begin within.
        """
        return pulumi.get(self, "start_window_duration")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the maintenance event.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the maintenance event was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The time at which the Maintenance actually finished.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeHardDueDate")
    def time_hard_due_date(self) -> str:
        """
        It is the scheduled hard due date and time of the maintenance event. The maintenance event will happen at this time and the due date will not be extended.
        """
        return pulumi.get(self, "time_hard_due_date")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The time at which the Maintenance actually started.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeWindowStart")
    def time_window_start(self) -> str:
        """
        The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before this time.
        """
        return pulumi.get(self, "time_window_start")


class AwaitableGetInstanceMaintenanceEventResult(GetInstanceMaintenanceEventResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceMaintenanceEventResult(
            additional_details=self.additional_details,
            alternative_resolution_action=self.alternative_resolution_action,
            alternative_resolution_actions=self.alternative_resolution_actions,
            can_delete_local_storage=self.can_delete_local_storage,
            can_reschedule=self.can_reschedule,
            compartment_id=self.compartment_id,
            correlation_token=self.correlation_token,
            created_by=self.created_by,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            estimated_duration=self.estimated_duration,
            freeform_tags=self.freeform_tags,
            id=self.id,
            instance_action=self.instance_action,
            instance_id=self.instance_id,
            instance_maintenance_event_id=self.instance_maintenance_event_id,
            maintenance_category=self.maintenance_category,
            maintenance_reason=self.maintenance_reason,
            start_window_duration=self.start_window_duration,
            state=self.state,
            time_created=self.time_created,
            time_finished=self.time_finished,
            time_hard_due_date=self.time_hard_due_date,
            time_started=self.time_started,
            time_window_start=self.time_window_start)


def get_instance_maintenance_event(instance_maintenance_event_id: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceMaintenanceEventResult:
    """
    This data source provides details about a specific Instance Maintenance Event resource in Oracle Cloud Infrastructure Core service.

    Gets the maintenance event for the given instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_maintenance_event = oci.Core.get_instance_maintenance_event(instance_maintenance_event_id=test_instance_maintenance_event_oci_core_instance_maintenance_event["id"])
    ```


    :param str instance_maintenance_event_id: The OCID of the instance maintenance event.
    """
    __args__ = dict()
    __args__['instanceMaintenanceEventId'] = instance_maintenance_event_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInstanceMaintenanceEvent:getInstanceMaintenanceEvent', __args__, opts=opts, typ=GetInstanceMaintenanceEventResult).value

    return AwaitableGetInstanceMaintenanceEventResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        alternative_resolution_action=pulumi.get(__ret__, 'alternative_resolution_action'),
        alternative_resolution_actions=pulumi.get(__ret__, 'alternative_resolution_actions'),
        can_delete_local_storage=pulumi.get(__ret__, 'can_delete_local_storage'),
        can_reschedule=pulumi.get(__ret__, 'can_reschedule'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        correlation_token=pulumi.get(__ret__, 'correlation_token'),
        created_by=pulumi.get(__ret__, 'created_by'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        estimated_duration=pulumi.get(__ret__, 'estimated_duration'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        instance_action=pulumi.get(__ret__, 'instance_action'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instance_maintenance_event_id=pulumi.get(__ret__, 'instance_maintenance_event_id'),
        maintenance_category=pulumi.get(__ret__, 'maintenance_category'),
        maintenance_reason=pulumi.get(__ret__, 'maintenance_reason'),
        start_window_duration=pulumi.get(__ret__, 'start_window_duration'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_hard_due_date=pulumi.get(__ret__, 'time_hard_due_date'),
        time_started=pulumi.get(__ret__, 'time_started'),
        time_window_start=pulumi.get(__ret__, 'time_window_start'))


@_utilities.lift_output_func(get_instance_maintenance_event)
def get_instance_maintenance_event_output(instance_maintenance_event_id: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceMaintenanceEventResult]:
    """
    This data source provides details about a specific Instance Maintenance Event resource in Oracle Cloud Infrastructure Core service.

    Gets the maintenance event for the given instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_maintenance_event = oci.Core.get_instance_maintenance_event(instance_maintenance_event_id=test_instance_maintenance_event_oci_core_instance_maintenance_event["id"])
    ```


    :param str instance_maintenance_event_id: The OCID of the instance maintenance event.
    """
    ...
