# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 job_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 suspend_trigger: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[str] job_id: The OCID of the job
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the job.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[int] suspend_trigger: (Updatable) An optional property when incremented triggers Suspend. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "job_id", job_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if suspend_trigger is not None:
            pulumi.set(__self__, "suspend_trigger", suspend_trigger)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Input[str]:
        """
        The OCID of the job
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="suspendTrigger")
    def suspend_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Suspend. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "suspend_trigger")

    @suspend_trigger.setter
    def suspend_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "suspend_trigger", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 migration_id: Optional[pulumi.Input[str]] = None,
                 parameter_file_versions: Optional[pulumi.Input[Sequence[pulumi.Input['JobParameterFileVersionArgs']]]] = None,
                 progresses: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 suspend_trigger: Optional[pulumi.Input[int]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unsupported_objects: Optional[pulumi.Input[Sequence[pulumi.Input['JobUnsupportedObjectArgs']]]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the job.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[str] job_id: The OCID of the job
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] migration_id: The OCID of the Migration that this job belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['JobParameterFileVersionArgs']]] parameter_file_versions: A list of parameter file versions that can be viewed or edited for the current job.
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressArgs']]] progresses: Percent progress of job phase.
        :param pulumi.Input[str] state: The current state of the migration job.
        :param pulumi.Input[int] suspend_trigger: (Updatable) An optional property when incremented triggers Suspend. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the Migration Job was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Migration Job was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[str] type: Type of unsupported object
        :param pulumi.Input[Sequence[pulumi.Input['JobUnsupportedObjectArgs']]] unsupported_objects: Database objects not supported.
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if migration_id is not None:
            pulumi.set(__self__, "migration_id", migration_id)
        if parameter_file_versions is not None:
            pulumi.set(__self__, "parameter_file_versions", parameter_file_versions)
        if progresses is not None:
            pulumi.set(__self__, "progresses", progresses)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if suspend_trigger is not None:
            pulumi.set(__self__, "suspend_trigger", suspend_trigger)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unsupported_objects is not None:
            pulumi.set(__self__, "unsupported_objects", unsupported_objects)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the job
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Migration that this job belongs to.
        """
        return pulumi.get(self, "migration_id")

    @migration_id.setter
    def migration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_id", value)

    @property
    @pulumi.getter(name="parameterFileVersions")
    def parameter_file_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobParameterFileVersionArgs']]]]:
        """
        A list of parameter file versions that can be viewed or edited for the current job.
        """
        return pulumi.get(self, "parameter_file_versions")

    @parameter_file_versions.setter
    def parameter_file_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobParameterFileVersionArgs']]]]):
        pulumi.set(self, "parameter_file_versions", value)

    @property
    @pulumi.getter
    def progresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressArgs']]]]:
        """
        Percent progress of job phase.
        """
        return pulumi.get(self, "progresses")

    @progresses.setter
    def progresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressArgs']]]]):
        pulumi.set(self, "progresses", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the migration job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="suspendTrigger")
    def suspend_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Suspend. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "suspend_trigger")

    @suspend_trigger.setter
    def suspend_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "suspend_trigger", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Migration Job was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Migration Job was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="unsupportedObjects")
    def unsupported_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobUnsupportedObjectArgs']]]]:
        """
        Database objects not supported.
        """
        return pulumi.get(self, "unsupported_objects")

    @unsupported_objects.setter
    def unsupported_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobUnsupportedObjectArgs']]]]):
        pulumi.set(self, "unsupported_objects", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 suspend_trigger: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Jobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseMigration/job:Job test_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the job.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[str] job_id: The OCID of the job
        :param pulumi.Input[int] suspend_trigger: (Updatable) An optional property when incremented triggers Suspend. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Jobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseMigration/job:Job test_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 suspend_trigger: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if job_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_id'")
            __props__.__dict__["job_id"] = job_id
            __props__.__dict__["suspend_trigger"] = suspend_trigger
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["migration_id"] = None
            __props__.__dict__["parameter_file_versions"] = None
            __props__.__dict__["progresses"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["unsupported_objects"] = None
        super(Job, __self__).__init__(
            'oci:DatabaseMigration/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            job_id: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            migration_id: Optional[pulumi.Input[str]] = None,
            parameter_file_versions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobParameterFileVersionArgs']]]]] = None,
            progresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobProgressArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            suspend_trigger: Optional[pulumi.Input[int]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            unsupported_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobUnsupportedObjectArgs']]]]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the job.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[str] job_id: The OCID of the job
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] migration_id: The OCID of the Migration that this job belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobParameterFileVersionArgs']]]] parameter_file_versions: A list of parameter file versions that can be viewed or edited for the current job.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobProgressArgs']]]] progresses: Percent progress of job phase.
        :param pulumi.Input[str] state: The current state of the migration job.
        :param pulumi.Input[int] suspend_trigger: (Updatable) An optional property when incremented triggers Suspend. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the Migration Job was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Migration Job was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[str] type: Type of unsupported object
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobUnsupportedObjectArgs']]]] unsupported_objects: Database objects not supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["migration_id"] = migration_id
        __props__.__dict__["parameter_file_versions"] = parameter_file_versions
        __props__.__dict__["progresses"] = progresses
        __props__.__dict__["state"] = state
        __props__.__dict__["suspend_trigger"] = suspend_trigger
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["unsupported_objects"] = unsupported_objects
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[str]:
        """
        The OCID of the job
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Migration that this job belongs to.
        """
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter(name="parameterFileVersions")
    def parameter_file_versions(self) -> pulumi.Output[Sequence['outputs.JobParameterFileVersion']]:
        """
        A list of parameter file versions that can be viewed or edited for the current job.
        """
        return pulumi.get(self, "parameter_file_versions")

    @property
    @pulumi.getter
    def progresses(self) -> pulumi.Output[Sequence['outputs.JobProgress']]:
        """
        Percent progress of job phase.
        """
        return pulumi.get(self, "progresses")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the migration job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="suspendTrigger")
    def suspend_trigger(self) -> pulumi.Output[Optional[int]]:
        """
        (Updatable) An optional property when incremented triggers Suspend. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "suspend_trigger")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the Migration Job was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the Migration Job was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="unsupportedObjects")
    def unsupported_objects(self) -> pulumi.Output[Sequence['outputs.JobUnsupportedObject']]:
        """
        Database objects not supported.
        """
        return pulumi.get(self, "unsupported_objects")

