# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIdpGroupMappingsResult',
    'AwaitableGetIdpGroupMappingsResult',
    'get_idp_group_mappings',
    'get_idp_group_mappings_output',
]

@pulumi.output_type
class GetIdpGroupMappingsResult:
    """
    A collection of values returned by getIdpGroupMappings.
    """
    def __init__(__self__, filters=None, id=None, identity_provider_id=None, idp_group_mappings=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_provider_id and not isinstance(identity_provider_id, str):
            raise TypeError("Expected argument 'identity_provider_id' to be a str")
        pulumi.set(__self__, "identity_provider_id", identity_provider_id)
        if idp_group_mappings and not isinstance(idp_group_mappings, list):
            raise TypeError("Expected argument 'idp_group_mappings' to be a list")
        pulumi.set(__self__, "idp_group_mappings", idp_group_mappings)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIdpGroupMappingsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityProviderId")
    def identity_provider_id(self) -> str:
        """
        The OCID of the `IdentityProvider` this mapping belongs to.
        """
        return pulumi.get(self, "identity_provider_id")

    @property
    @pulumi.getter(name="idpGroupMappings")
    def idp_group_mappings(self) -> Sequence['outputs.GetIdpGroupMappingsIdpGroupMappingResult']:
        """
        The list of idp_group_mappings.
        """
        return pulumi.get(self, "idp_group_mappings")


class AwaitableGetIdpGroupMappingsResult(GetIdpGroupMappingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIdpGroupMappingsResult(
            filters=self.filters,
            id=self.id,
            identity_provider_id=self.identity_provider_id,
            idp_group_mappings=self.idp_group_mappings)


def get_idp_group_mappings(filters: Optional[Sequence[pulumi.InputType['GetIdpGroupMappingsFilterArgs']]] = None,
                           identity_provider_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIdpGroupMappingsResult:
    """
    This data source provides the list of Idp Group Mappings in Oracle Cloud Infrastructure Identity service.

    **Deprecated.** For more information, see [Deprecated IAM Service APIs](https://docs.cloud.oracle.com/iaas/Content/Identity/Reference/deprecatediamapis.htm).

    Lists the group mappings for the specified identity provider.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_idp_group_mappings = oci.Identity.get_idp_group_mappings(identity_provider_id=test_identity_provider["id"])
    ```


    :param str identity_provider_id: The OCID of the identity provider.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['identityProviderId'] = identity_provider_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getIdpGroupMappings:getIdpGroupMappings', __args__, opts=opts, typ=GetIdpGroupMappingsResult).value

    return AwaitableGetIdpGroupMappingsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        identity_provider_id=pulumi.get(__ret__, 'identity_provider_id'),
        idp_group_mappings=pulumi.get(__ret__, 'idp_group_mappings'))


@_utilities.lift_output_func(get_idp_group_mappings)
def get_idp_group_mappings_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetIdpGroupMappingsFilterArgs']]]]] = None,
                                  identity_provider_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIdpGroupMappingsResult]:
    """
    This data source provides the list of Idp Group Mappings in Oracle Cloud Infrastructure Identity service.

    **Deprecated.** For more information, see [Deprecated IAM Service APIs](https://docs.cloud.oracle.com/iaas/Content/Identity/Reference/deprecatediamapis.htm).

    Lists the group mappings for the specified identity provider.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_idp_group_mappings = oci.Identity.get_idp_group_mappings(identity_provider_id=test_identity_provider["id"])
    ```


    :param str identity_provider_id: The OCID of the identity provider.
    """
    ...
