# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EsxiHostArgs', 'EsxiHost']

@pulumi.input_type
class EsxiHostArgs:
    def __init__(__self__, *,
                 billing_donor_host_id: Optional[pulumi.Input[str]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[str]] = None,
                 current_sku: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 esxi_software_version: Optional[pulumi.Input[str]] = None,
                 failed_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_ocpu_count: Optional[pulumi.Input[float]] = None,
                 host_shape_name: Optional[pulumi.Input[str]] = None,
                 next_sku: Optional[pulumi.Input[str]] = None,
                 non_upgraded_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 sddc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EsxiHost resource.
        :param pulumi.Input[str] billing_donor_host_id: (Optional) (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        :param pulumi.Input[str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[str] cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster to add the ESXi host to.
        :param pulumi.Input[str] compute_availability_domain: The availability domain to create the ESXi host in. If keep empty, for AD-specific Cluster, new ESXi host will be created in the same availability domain; for multi-AD Cluster, new ESXi host will be auto assigned to the next availability domain following evenly distribution strategy.
        :param pulumi.Input[str] current_sku: (Optional) The billing option currently used by the ESXi host. It is only effective during resource creation. Changes to its value after creation will be ignored. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus). **Deprecated**. Please use `current_commitment` instead.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A descriptive name for the ESXi host. It's changeable. Esxi Host name requirements are 1-16 character length limit, Must start with a letter,  Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the Cluster.
               
               If this attribute is not specified, the Cluster's `instanceDisplayNamePrefix` attribute is used to name and incrementally number the ESXi host. For example, if you're creating the fourth ESXi host in the Cluster, and `instanceDisplayNamePrefix` is `MyCluster`, the host's display name is `MyCluster-4`.
               
               Avoid entering confidential information.
        :param pulumi.Input[str] esxi_software_version: (Updatable) The ESXi software bundle to install on the ESXi host.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[str] failed_esxi_host_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is failed. This is an optional parameter. If this parameter is specified, a new ESXi host will be created to replace the failed one, and the `failedEsxiHostId` field will be updated in the newly created Esxi host.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[float] host_ocpu_count: The OCPU count of the ESXi host.
        :param pulumi.Input[str] host_shape_name: The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[str] non_upgraded_esxi_host_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded. This is an optional parameter. If this parameter is specified, an ESXi host with the new software version is created to replace the original one, and the `nonUpgradedEsxiHostId` field is updated in the newly created Esxi host. See [Upgrading VMware Software](https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/upgrade.htm) for more information.
        :param pulumi.Input[str] sddc_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC to add the ESXi host to. This field has been deprecated. Please use `cluster_id` instead. Either `sddc_id` or `cluster_id` must be configured for `Ocvp.EsxiHost` resource.  **Deprecated**. Please use `cluster_id` instead.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if billing_donor_host_id is not None:
            warnings.warn("""This 'billing_donor_host_id' argument has been deprecated and will be computed only.""", DeprecationWarning)
            pulumi.log.warn("""billing_donor_host_id is deprecated: This 'billing_donor_host_id' argument has been deprecated and will be computed only.""")
        if billing_donor_host_id is not None:
            pulumi.set(__self__, "billing_donor_host_id", billing_donor_host_id)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if compute_availability_domain is not None:
            pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        if current_sku is not None:
            warnings.warn("""The 'current_sku' field has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""current_sku is deprecated: The 'current_sku' field has been deprecated. It is no longer supported.""")
        if current_sku is not None:
            pulumi.set(__self__, "current_sku", current_sku)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if esxi_software_version is not None:
            pulumi.set(__self__, "esxi_software_version", esxi_software_version)
        if failed_esxi_host_id is not None:
            warnings.warn("""This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""", DeprecationWarning)
            pulumi.log.warn("""failed_esxi_host_id is deprecated: This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""")
        if failed_esxi_host_id is not None:
            pulumi.set(__self__, "failed_esxi_host_id", failed_esxi_host_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_ocpu_count is not None:
            pulumi.set(__self__, "host_ocpu_count", host_ocpu_count)
        if host_shape_name is not None:
            pulumi.set(__self__, "host_shape_name", host_shape_name)
        if next_sku is not None:
            warnings.warn("""The 'next_sku' field has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""next_sku is deprecated: The 'next_sku' field has been deprecated. It is no longer supported.""")
        if next_sku is not None:
            pulumi.set(__self__, "next_sku", next_sku)
        if non_upgraded_esxi_host_id is not None:
            warnings.warn("""This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""", DeprecationWarning)
            pulumi.log.warn("""non_upgraded_esxi_host_id is deprecated: This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""")
        if non_upgraded_esxi_host_id is not None:
            pulumi.set(__self__, "non_upgraded_esxi_host_id", non_upgraded_esxi_host_id)
        if sddc_id is not None:
            warnings.warn("""The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""sddc_id is deprecated: The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""")
        if sddc_id is not None:
            pulumi.set(__self__, "sddc_id", sddc_id)

    @property
    @pulumi.getter(name="billingDonorHostId")
    @_utilities.deprecated("""This 'billing_donor_host_id' argument has been deprecated and will be computed only.""")
    def billing_donor_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        """
        return pulumi.get(self, "billing_donor_host_id")

    @billing_donor_host_id.setter
    def billing_donor_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_donor_host_id", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster to add the ESXi host to.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain to create the ESXi host in. If keep empty, for AD-specific Cluster, new ESXi host will be created in the same availability domain; for multi-AD Cluster, new ESXi host will be auto assigned to the next availability domain following evenly distribution strategy.
        """
        return pulumi.get(self, "compute_availability_domain")

    @compute_availability_domain.setter
    def compute_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_availability_domain", value)

    @property
    @pulumi.getter(name="currentSku")
    @_utilities.deprecated("""The 'current_sku' field has been deprecated. It is no longer supported.""")
    def current_sku(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) The billing option currently used by the ESXi host. It is only effective during resource creation. Changes to its value after creation will be ignored. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus). **Deprecated**. Please use `current_commitment` instead.
        """
        return pulumi.get(self, "current_sku")

    @current_sku.setter
    def current_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_sku", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A descriptive name for the ESXi host. It's changeable. Esxi Host name requirements are 1-16 character length limit, Must start with a letter,  Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the Cluster.

        If this attribute is not specified, the Cluster's `instanceDisplayNamePrefix` attribute is used to name and incrementally number the ESXi host. For example, if you're creating the fourth ESXi host in the Cluster, and `instanceDisplayNamePrefix` is `MyCluster`, the host's display name is `MyCluster-4`.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The ESXi software bundle to install on the ESXi host.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "esxi_software_version")

    @esxi_software_version.setter
    def esxi_software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "esxi_software_version", value)

    @property
    @pulumi.getter(name="failedEsxiHostId")
    @_utilities.deprecated("""This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""")
    def failed_esxi_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is failed. This is an optional parameter. If this parameter is specified, a new ESXi host will be created to replace the failed one, and the `failedEsxiHostId` field will be updated in the newly created Esxi host.
        """
        return pulumi.get(self, "failed_esxi_host_id")

    @failed_esxi_host_id.setter
    def failed_esxi_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failed_esxi_host_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostOcpuCount")
    def host_ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        The OCPU count of the ESXi host.
        """
        return pulumi.get(self, "host_ocpu_count")

    @host_ocpu_count.setter
    def host_ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "host_ocpu_count", value)

    @property
    @pulumi.getter(name="hostShapeName")
    def host_shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "host_shape_name")

    @host_shape_name.setter
    def host_shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_shape_name", value)

    @property
    @pulumi.getter(name="nextSku")
    @_utilities.deprecated("""The 'next_sku' field has been deprecated. It is no longer supported.""")
    def next_sku(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "next_sku")

    @next_sku.setter
    def next_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_sku", value)

    @property
    @pulumi.getter(name="nonUpgradedEsxiHostId")
    @_utilities.deprecated("""This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""")
    def non_upgraded_esxi_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded. This is an optional parameter. If this parameter is specified, an ESXi host with the new software version is created to replace the original one, and the `nonUpgradedEsxiHostId` field is updated in the newly created Esxi host. See [Upgrading VMware Software](https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/upgrade.htm) for more information.
        """
        return pulumi.get(self, "non_upgraded_esxi_host_id")

    @non_upgraded_esxi_host_id.setter
    def non_upgraded_esxi_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "non_upgraded_esxi_host_id", value)

    @property
    @pulumi.getter(name="sddcId")
    @_utilities.deprecated("""The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""")
    def sddc_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC to add the ESXi host to. This field has been deprecated. Please use `cluster_id` instead. Either `sddc_id` or `cluster_id` must be configured for `Ocvp.EsxiHost` resource.  **Deprecated**. Please use `cluster_id` instead.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sddc_id")

    @sddc_id.setter
    def sddc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sddc_id", value)


@pulumi.input_type
class _EsxiHostState:
    def __init__(__self__, *,
                 billing_contract_end_date: Optional[pulumi.Input[str]] = None,
                 billing_donor_host_id: Optional[pulumi.Input[str]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[str]] = None,
                 compute_instance_id: Optional[pulumi.Input[str]] = None,
                 current_commitment: Optional[pulumi.Input[str]] = None,
                 current_sku: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 esxi_software_version: Optional[pulumi.Input[str]] = None,
                 failed_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 grace_period_end_date: Optional[pulumi.Input[str]] = None,
                 host_ocpu_count: Optional[pulumi.Input[float]] = None,
                 host_shape_name: Optional[pulumi.Input[str]] = None,
                 is_billing_continuation_in_progress: Optional[pulumi.Input[bool]] = None,
                 is_billing_swapping_in_progress: Optional[pulumi.Input[bool]] = None,
                 next_commitment: Optional[pulumi.Input[str]] = None,
                 next_sku: Optional[pulumi.Input[str]] = None,
                 non_upgraded_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 replacement_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 sddc_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 swap_billing_host_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 upgraded_replacement_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 vmware_software_version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EsxiHost resources.
        :param pulumi.Input[str] billing_contract_end_date: Current billing cycle end date. If the value in `currentCommitment` and `nextCommitment` are different, the value specified in `nextCommitment` becomes the new `currentCommitment` when the `contractEndDate` is reached. Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] billing_donor_host_id: (Optional) (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        :param pulumi.Input[str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[str] cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster to add the ESXi host to.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        :param pulumi.Input[str] compute_availability_domain: The availability domain to create the ESXi host in. If keep empty, for AD-specific Cluster, new ESXi host will be created in the same availability domain; for multi-AD Cluster, new ESXi host will be auto assigned to the next availability domain following evenly distribution strategy.
        :param pulumi.Input[str] compute_instance_id: In terms of implementation, an ESXi host is a Compute instance that is configured with the chosen bundle of VMware software. The `computeInstanceId` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that Compute instance.
        :param pulumi.Input[str] current_commitment: The billing option currently used by the ESXi host. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        :param pulumi.Input[str] current_sku: (Optional) The billing option currently used by the ESXi host. It is only effective during resource creation. Changes to its value after creation will be ignored. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus). **Deprecated**. Please use `current_commitment` instead.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A descriptive name for the ESXi host. It's changeable. Esxi Host name requirements are 1-16 character length limit, Must start with a letter,  Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the Cluster.
               
               If this attribute is not specified, the Cluster's `instanceDisplayNamePrefix` attribute is used to name and incrementally number the ESXi host. For example, if you're creating the fourth ESXi host in the Cluster, and `instanceDisplayNamePrefix` is `MyCluster`, the host's display name is `MyCluster-4`.
               
               Avoid entering confidential information.
        :param pulumi.Input[str] esxi_software_version: (Updatable) The ESXi software bundle to install on the ESXi host.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[str] failed_esxi_host_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is failed. This is an optional parameter. If this parameter is specified, a new ESXi host will be created to replace the failed one, and the `failedEsxiHostId` field will be updated in the newly created Esxi host.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] grace_period_end_date: The date and time when the new esxi host should start billing cycle. [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2021-07-25T21:10:29.600Z`
        :param pulumi.Input[float] host_ocpu_count: The OCPU count of the ESXi host.
        :param pulumi.Input[str] host_shape_name: The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[bool] is_billing_continuation_in_progress: Indicates whether this host is in the progress of billing continuation.
        :param pulumi.Input[bool] is_billing_swapping_in_progress: Indicates whether this host is in the progress of swapping billing.
        :param pulumi.Input[str] next_commitment: The billing option to switch to after the current billing cycle ends. If `nextCommitment` is null or empty, `currentCommitment` continues to the next billing cycle. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        :param pulumi.Input[str] non_upgraded_esxi_host_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded. This is an optional parameter. If this parameter is specified, an ESXi host with the new software version is created to replace the original one, and the `nonUpgradedEsxiHostId` field is updated in the newly created Esxi host. See [Upgrading VMware Software](https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/upgrade.htm) for more information.
        :param pulumi.Input[str] replacement_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the esxi host that is newly created to replace the failed node.
        :param pulumi.Input[str] sddc_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC to add the ESXi host to. This field has been deprecated. Please use `cluster_id` instead. Either `sddc_id` or `cluster_id` must be configured for `Ocvp.EsxiHost` resource.  **Deprecated**. Please use `cluster_id` instead.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the ESXi host.
        :param pulumi.Input[str] swap_billing_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the active ESXi Host to swap billing with current host.
        :param pulumi.Input[str] time_created: The date and time the ESXi host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the ESXi host was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] upgraded_replacement_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is newly created to upgrade the original host.
        :param pulumi.Input[str] vmware_software_version: The version of VMware software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        if billing_contract_end_date is not None:
            pulumi.set(__self__, "billing_contract_end_date", billing_contract_end_date)
        if billing_donor_host_id is not None:
            warnings.warn("""This 'billing_donor_host_id' argument has been deprecated and will be computed only.""", DeprecationWarning)
            pulumi.log.warn("""billing_donor_host_id is deprecated: This 'billing_donor_host_id' argument has been deprecated and will be computed only.""")
        if billing_donor_host_id is not None:
            pulumi.set(__self__, "billing_donor_host_id", billing_donor_host_id)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_availability_domain is not None:
            pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        if compute_instance_id is not None:
            pulumi.set(__self__, "compute_instance_id", compute_instance_id)
        if current_commitment is not None:
            pulumi.set(__self__, "current_commitment", current_commitment)
        if current_sku is not None:
            warnings.warn("""The 'current_sku' field has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""current_sku is deprecated: The 'current_sku' field has been deprecated. It is no longer supported.""")
        if current_sku is not None:
            pulumi.set(__self__, "current_sku", current_sku)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if esxi_software_version is not None:
            pulumi.set(__self__, "esxi_software_version", esxi_software_version)
        if failed_esxi_host_id is not None:
            warnings.warn("""This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""", DeprecationWarning)
            pulumi.log.warn("""failed_esxi_host_id is deprecated: This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""")
        if failed_esxi_host_id is not None:
            pulumi.set(__self__, "failed_esxi_host_id", failed_esxi_host_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if grace_period_end_date is not None:
            pulumi.set(__self__, "grace_period_end_date", grace_period_end_date)
        if host_ocpu_count is not None:
            pulumi.set(__self__, "host_ocpu_count", host_ocpu_count)
        if host_shape_name is not None:
            pulumi.set(__self__, "host_shape_name", host_shape_name)
        if is_billing_continuation_in_progress is not None:
            pulumi.set(__self__, "is_billing_continuation_in_progress", is_billing_continuation_in_progress)
        if is_billing_swapping_in_progress is not None:
            pulumi.set(__self__, "is_billing_swapping_in_progress", is_billing_swapping_in_progress)
        if next_commitment is not None:
            pulumi.set(__self__, "next_commitment", next_commitment)
        if next_sku is not None:
            warnings.warn("""The 'next_sku' field has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""next_sku is deprecated: The 'next_sku' field has been deprecated. It is no longer supported.""")
        if next_sku is not None:
            pulumi.set(__self__, "next_sku", next_sku)
        if non_upgraded_esxi_host_id is not None:
            warnings.warn("""This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""", DeprecationWarning)
            pulumi.log.warn("""non_upgraded_esxi_host_id is deprecated: This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""")
        if non_upgraded_esxi_host_id is not None:
            pulumi.set(__self__, "non_upgraded_esxi_host_id", non_upgraded_esxi_host_id)
        if replacement_esxi_host_id is not None:
            pulumi.set(__self__, "replacement_esxi_host_id", replacement_esxi_host_id)
        if sddc_id is not None:
            warnings.warn("""The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""sddc_id is deprecated: The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""")
        if sddc_id is not None:
            pulumi.set(__self__, "sddc_id", sddc_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if swap_billing_host_id is not None:
            pulumi.set(__self__, "swap_billing_host_id", swap_billing_host_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if upgraded_replacement_esxi_host_id is not None:
            pulumi.set(__self__, "upgraded_replacement_esxi_host_id", upgraded_replacement_esxi_host_id)
        if vmware_software_version is not None:
            pulumi.set(__self__, "vmware_software_version", vmware_software_version)

    @property
    @pulumi.getter(name="billingContractEndDate")
    def billing_contract_end_date(self) -> Optional[pulumi.Input[str]]:
        """
        Current billing cycle end date. If the value in `currentCommitment` and `nextCommitment` are different, the value specified in `nextCommitment` becomes the new `currentCommitment` when the `contractEndDate` is reached. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "billing_contract_end_date")

    @billing_contract_end_date.setter
    def billing_contract_end_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_contract_end_date", value)

    @property
    @pulumi.getter(name="billingDonorHostId")
    @_utilities.deprecated("""This 'billing_donor_host_id' argument has been deprecated and will be computed only.""")
    def billing_donor_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        """
        return pulumi.get(self, "billing_donor_host_id")

    @billing_donor_host_id.setter
    def billing_donor_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_donor_host_id", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster to add the ESXi host to.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain to create the ESXi host in. If keep empty, for AD-specific Cluster, new ESXi host will be created in the same availability domain; for multi-AD Cluster, new ESXi host will be auto assigned to the next availability domain following evenly distribution strategy.
        """
        return pulumi.get(self, "compute_availability_domain")

    @compute_availability_domain.setter
    def compute_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_availability_domain", value)

    @property
    @pulumi.getter(name="computeInstanceId")
    def compute_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        In terms of implementation, an ESXi host is a Compute instance that is configured with the chosen bundle of VMware software. The `computeInstanceId` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that Compute instance.
        """
        return pulumi.get(self, "compute_instance_id")

    @compute_instance_id.setter
    def compute_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_instance_id", value)

    @property
    @pulumi.getter(name="currentCommitment")
    def current_commitment(self) -> Optional[pulumi.Input[str]]:
        """
        The billing option currently used by the ESXi host. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "current_commitment")

    @current_commitment.setter
    def current_commitment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_commitment", value)

    @property
    @pulumi.getter(name="currentSku")
    @_utilities.deprecated("""The 'current_sku' field has been deprecated. It is no longer supported.""")
    def current_sku(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) The billing option currently used by the ESXi host. It is only effective during resource creation. Changes to its value after creation will be ignored. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus). **Deprecated**. Please use `current_commitment` instead.
        """
        return pulumi.get(self, "current_sku")

    @current_sku.setter
    def current_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_sku", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A descriptive name for the ESXi host. It's changeable. Esxi Host name requirements are 1-16 character length limit, Must start with a letter,  Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the Cluster.

        If this attribute is not specified, the Cluster's `instanceDisplayNamePrefix` attribute is used to name and incrementally number the ESXi host. For example, if you're creating the fourth ESXi host in the Cluster, and `instanceDisplayNamePrefix` is `MyCluster`, the host's display name is `MyCluster-4`.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The ESXi software bundle to install on the ESXi host.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "esxi_software_version")

    @esxi_software_version.setter
    def esxi_software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "esxi_software_version", value)

    @property
    @pulumi.getter(name="failedEsxiHostId")
    @_utilities.deprecated("""This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""")
    def failed_esxi_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is failed. This is an optional parameter. If this parameter is specified, a new ESXi host will be created to replace the failed one, and the `failedEsxiHostId` field will be updated in the newly created Esxi host.
        """
        return pulumi.get(self, "failed_esxi_host_id")

    @failed_esxi_host_id.setter
    def failed_esxi_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failed_esxi_host_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="gracePeriodEndDate")
    def grace_period_end_date(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the new esxi host should start billing cycle. [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2021-07-25T21:10:29.600Z`
        """
        return pulumi.get(self, "grace_period_end_date")

    @grace_period_end_date.setter
    def grace_period_end_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grace_period_end_date", value)

    @property
    @pulumi.getter(name="hostOcpuCount")
    def host_ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        The OCPU count of the ESXi host.
        """
        return pulumi.get(self, "host_ocpu_count")

    @host_ocpu_count.setter
    def host_ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "host_ocpu_count", value)

    @property
    @pulumi.getter(name="hostShapeName")
    def host_shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "host_shape_name")

    @host_shape_name.setter
    def host_shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_shape_name", value)

    @property
    @pulumi.getter(name="isBillingContinuationInProgress")
    def is_billing_continuation_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this host is in the progress of billing continuation.
        """
        return pulumi.get(self, "is_billing_continuation_in_progress")

    @is_billing_continuation_in_progress.setter
    def is_billing_continuation_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_billing_continuation_in_progress", value)

    @property
    @pulumi.getter(name="isBillingSwappingInProgress")
    def is_billing_swapping_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this host is in the progress of swapping billing.
        """
        return pulumi.get(self, "is_billing_swapping_in_progress")

    @is_billing_swapping_in_progress.setter
    def is_billing_swapping_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_billing_swapping_in_progress", value)

    @property
    @pulumi.getter(name="nextCommitment")
    def next_commitment(self) -> Optional[pulumi.Input[str]]:
        """
        The billing option to switch to after the current billing cycle ends. If `nextCommitment` is null or empty, `currentCommitment` continues to the next billing cycle. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "next_commitment")

    @next_commitment.setter
    def next_commitment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_commitment", value)

    @property
    @pulumi.getter(name="nextSku")
    @_utilities.deprecated("""The 'next_sku' field has been deprecated. It is no longer supported.""")
    def next_sku(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "next_sku")

    @next_sku.setter
    def next_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_sku", value)

    @property
    @pulumi.getter(name="nonUpgradedEsxiHostId")
    @_utilities.deprecated("""This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""")
    def non_upgraded_esxi_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded. This is an optional parameter. If this parameter is specified, an ESXi host with the new software version is created to replace the original one, and the `nonUpgradedEsxiHostId` field is updated in the newly created Esxi host. See [Upgrading VMware Software](https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/upgrade.htm) for more information.
        """
        return pulumi.get(self, "non_upgraded_esxi_host_id")

    @non_upgraded_esxi_host_id.setter
    def non_upgraded_esxi_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "non_upgraded_esxi_host_id", value)

    @property
    @pulumi.getter(name="replacementEsxiHostId")
    def replacement_esxi_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the esxi host that is newly created to replace the failed node.
        """
        return pulumi.get(self, "replacement_esxi_host_id")

    @replacement_esxi_host_id.setter
    def replacement_esxi_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replacement_esxi_host_id", value)

    @property
    @pulumi.getter(name="sddcId")
    @_utilities.deprecated("""The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""")
    def sddc_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC to add the ESXi host to. This field has been deprecated. Please use `cluster_id` instead. Either `sddc_id` or `cluster_id` must be configured for `Ocvp.EsxiHost` resource.  **Deprecated**. Please use `cluster_id` instead.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sddc_id")

    @sddc_id.setter
    def sddc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sddc_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the ESXi host.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="swapBillingHostId")
    def swap_billing_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the active ESXi Host to swap billing with current host.
        """
        return pulumi.get(self, "swap_billing_host_id")

    @swap_billing_host_id.setter
    def swap_billing_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "swap_billing_host_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the ESXi host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the ESXi host was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="upgradedReplacementEsxiHostId")
    def upgraded_replacement_esxi_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is newly created to upgrade the original host.
        """
        return pulumi.get(self, "upgraded_replacement_esxi_host_id")

    @upgraded_replacement_esxi_host_id.setter
    def upgraded_replacement_esxi_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgraded_replacement_esxi_host_id", value)

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of VMware software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        return pulumi.get(self, "vmware_software_version")

    @vmware_software_version.setter
    def vmware_software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmware_software_version", value)


class EsxiHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_donor_host_id: Optional[pulumi.Input[str]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[str]] = None,
                 current_sku: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 esxi_software_version: Optional[pulumi.Input[str]] = None,
                 failed_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_ocpu_count: Optional[pulumi.Input[float]] = None,
                 host_shape_name: Optional[pulumi.Input[str]] = None,
                 next_sku: Optional[pulumi.Input[str]] = None,
                 non_upgraded_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 sddc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        EsxiHosts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Ocvp/esxiHost:EsxiHost test_esxi_host "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] billing_donor_host_id: (Optional) (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        :param pulumi.Input[str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[str] cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster to add the ESXi host to.
        :param pulumi.Input[str] compute_availability_domain: The availability domain to create the ESXi host in. If keep empty, for AD-specific Cluster, new ESXi host will be created in the same availability domain; for multi-AD Cluster, new ESXi host will be auto assigned to the next availability domain following evenly distribution strategy.
        :param pulumi.Input[str] current_sku: (Optional) The billing option currently used by the ESXi host. It is only effective during resource creation. Changes to its value after creation will be ignored. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus). **Deprecated**. Please use `current_commitment` instead.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A descriptive name for the ESXi host. It's changeable. Esxi Host name requirements are 1-16 character length limit, Must start with a letter,  Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the Cluster.
               
               If this attribute is not specified, the Cluster's `instanceDisplayNamePrefix` attribute is used to name and incrementally number the ESXi host. For example, if you're creating the fourth ESXi host in the Cluster, and `instanceDisplayNamePrefix` is `MyCluster`, the host's display name is `MyCluster-4`.
               
               Avoid entering confidential information.
        :param pulumi.Input[str] esxi_software_version: (Updatable) The ESXi software bundle to install on the ESXi host.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[str] failed_esxi_host_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is failed. This is an optional parameter. If this parameter is specified, a new ESXi host will be created to replace the failed one, and the `failedEsxiHostId` field will be updated in the newly created Esxi host.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[float] host_ocpu_count: The OCPU count of the ESXi host.
        :param pulumi.Input[str] host_shape_name: The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[str] non_upgraded_esxi_host_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded. This is an optional parameter. If this parameter is specified, an ESXi host with the new software version is created to replace the original one, and the `nonUpgradedEsxiHostId` field is updated in the newly created Esxi host. See [Upgrading VMware Software](https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/upgrade.htm) for more information.
        :param pulumi.Input[str] sddc_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC to add the ESXi host to. This field has been deprecated. Please use `cluster_id` instead. Either `sddc_id` or `cluster_id` must be configured for `Ocvp.EsxiHost` resource.  **Deprecated**. Please use `cluster_id` instead.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EsxiHostArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        EsxiHosts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Ocvp/esxiHost:EsxiHost test_esxi_host "id"
        ```

        :param str resource_name: The name of the resource.
        :param EsxiHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EsxiHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_donor_host_id: Optional[pulumi.Input[str]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[str]] = None,
                 current_sku: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 esxi_software_version: Optional[pulumi.Input[str]] = None,
                 failed_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_ocpu_count: Optional[pulumi.Input[float]] = None,
                 host_shape_name: Optional[pulumi.Input[str]] = None,
                 next_sku: Optional[pulumi.Input[str]] = None,
                 non_upgraded_esxi_host_id: Optional[pulumi.Input[str]] = None,
                 sddc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EsxiHostArgs.__new__(EsxiHostArgs)

            __props__.__dict__["billing_donor_host_id"] = billing_donor_host_id
            __props__.__dict__["capacity_reservation_id"] = capacity_reservation_id
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["compute_availability_domain"] = compute_availability_domain
            __props__.__dict__["current_sku"] = current_sku
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["esxi_software_version"] = esxi_software_version
            __props__.__dict__["failed_esxi_host_id"] = failed_esxi_host_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["host_ocpu_count"] = host_ocpu_count
            __props__.__dict__["host_shape_name"] = host_shape_name
            __props__.__dict__["next_sku"] = next_sku
            __props__.__dict__["non_upgraded_esxi_host_id"] = non_upgraded_esxi_host_id
            __props__.__dict__["sddc_id"] = sddc_id
            __props__.__dict__["billing_contract_end_date"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["compute_instance_id"] = None
            __props__.__dict__["current_commitment"] = None
            __props__.__dict__["grace_period_end_date"] = None
            __props__.__dict__["is_billing_continuation_in_progress"] = None
            __props__.__dict__["is_billing_swapping_in_progress"] = None
            __props__.__dict__["next_commitment"] = None
            __props__.__dict__["replacement_esxi_host_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["swap_billing_host_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["upgraded_replacement_esxi_host_id"] = None
            __props__.__dict__["vmware_software_version"] = None
        super(EsxiHost, __self__).__init__(
            'oci:Ocvp/esxiHost:EsxiHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            billing_contract_end_date: Optional[pulumi.Input[str]] = None,
            billing_donor_host_id: Optional[pulumi.Input[str]] = None,
            capacity_reservation_id: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_availability_domain: Optional[pulumi.Input[str]] = None,
            compute_instance_id: Optional[pulumi.Input[str]] = None,
            current_commitment: Optional[pulumi.Input[str]] = None,
            current_sku: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            esxi_software_version: Optional[pulumi.Input[str]] = None,
            failed_esxi_host_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            grace_period_end_date: Optional[pulumi.Input[str]] = None,
            host_ocpu_count: Optional[pulumi.Input[float]] = None,
            host_shape_name: Optional[pulumi.Input[str]] = None,
            is_billing_continuation_in_progress: Optional[pulumi.Input[bool]] = None,
            is_billing_swapping_in_progress: Optional[pulumi.Input[bool]] = None,
            next_commitment: Optional[pulumi.Input[str]] = None,
            next_sku: Optional[pulumi.Input[str]] = None,
            non_upgraded_esxi_host_id: Optional[pulumi.Input[str]] = None,
            replacement_esxi_host_id: Optional[pulumi.Input[str]] = None,
            sddc_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            swap_billing_host_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            upgraded_replacement_esxi_host_id: Optional[pulumi.Input[str]] = None,
            vmware_software_version: Optional[pulumi.Input[str]] = None) -> 'EsxiHost':
        """
        Get an existing EsxiHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] billing_contract_end_date: Current billing cycle end date. If the value in `currentCommitment` and `nextCommitment` are different, the value specified in `nextCommitment` becomes the new `currentCommitment` when the `contractEndDate` is reached. Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] billing_donor_host_id: (Optional) (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        :param pulumi.Input[str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[str] cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster to add the ESXi host to.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        :param pulumi.Input[str] compute_availability_domain: The availability domain to create the ESXi host in. If keep empty, for AD-specific Cluster, new ESXi host will be created in the same availability domain; for multi-AD Cluster, new ESXi host will be auto assigned to the next availability domain following evenly distribution strategy.
        :param pulumi.Input[str] compute_instance_id: In terms of implementation, an ESXi host is a Compute instance that is configured with the chosen bundle of VMware software. The `computeInstanceId` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that Compute instance.
        :param pulumi.Input[str] current_commitment: The billing option currently used by the ESXi host. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        :param pulumi.Input[str] current_sku: (Optional) The billing option currently used by the ESXi host. It is only effective during resource creation. Changes to its value after creation will be ignored. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus). **Deprecated**. Please use `current_commitment` instead.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A descriptive name for the ESXi host. It's changeable. Esxi Host name requirements are 1-16 character length limit, Must start with a letter,  Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the Cluster.
               
               If this attribute is not specified, the Cluster's `instanceDisplayNamePrefix` attribute is used to name and incrementally number the ESXi host. For example, if you're creating the fourth ESXi host in the Cluster, and `instanceDisplayNamePrefix` is `MyCluster`, the host's display name is `MyCluster-4`.
               
               Avoid entering confidential information.
        :param pulumi.Input[str] esxi_software_version: (Updatable) The ESXi software bundle to install on the ESXi host.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[str] failed_esxi_host_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is failed. This is an optional parameter. If this parameter is specified, a new ESXi host will be created to replace the failed one, and the `failedEsxiHostId` field will be updated in the newly created Esxi host.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] grace_period_end_date: The date and time when the new esxi host should start billing cycle. [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2021-07-25T21:10:29.600Z`
        :param pulumi.Input[float] host_ocpu_count: The OCPU count of the ESXi host.
        :param pulumi.Input[str] host_shape_name: The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[bool] is_billing_continuation_in_progress: Indicates whether this host is in the progress of billing continuation.
        :param pulumi.Input[bool] is_billing_swapping_in_progress: Indicates whether this host is in the progress of swapping billing.
        :param pulumi.Input[str] next_commitment: The billing option to switch to after the current billing cycle ends. If `nextCommitment` is null or empty, `currentCommitment` continues to the next billing cycle. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        :param pulumi.Input[str] non_upgraded_esxi_host_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded. This is an optional parameter. If this parameter is specified, an ESXi host with the new software version is created to replace the original one, and the `nonUpgradedEsxiHostId` field is updated in the newly created Esxi host. See [Upgrading VMware Software](https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/upgrade.htm) for more information.
        :param pulumi.Input[str] replacement_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the esxi host that is newly created to replace the failed node.
        :param pulumi.Input[str] sddc_id: (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC to add the ESXi host to. This field has been deprecated. Please use `cluster_id` instead. Either `sddc_id` or `cluster_id` must be configured for `Ocvp.EsxiHost` resource.  **Deprecated**. Please use `cluster_id` instead.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the ESXi host.
        :param pulumi.Input[str] swap_billing_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the active ESXi Host to swap billing with current host.
        :param pulumi.Input[str] time_created: The date and time the ESXi host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the ESXi host was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] upgraded_replacement_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is newly created to upgrade the original host.
        :param pulumi.Input[str] vmware_software_version: The version of VMware software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EsxiHostState.__new__(_EsxiHostState)

        __props__.__dict__["billing_contract_end_date"] = billing_contract_end_date
        __props__.__dict__["billing_donor_host_id"] = billing_donor_host_id
        __props__.__dict__["capacity_reservation_id"] = capacity_reservation_id
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_availability_domain"] = compute_availability_domain
        __props__.__dict__["compute_instance_id"] = compute_instance_id
        __props__.__dict__["current_commitment"] = current_commitment
        __props__.__dict__["current_sku"] = current_sku
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["esxi_software_version"] = esxi_software_version
        __props__.__dict__["failed_esxi_host_id"] = failed_esxi_host_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["grace_period_end_date"] = grace_period_end_date
        __props__.__dict__["host_ocpu_count"] = host_ocpu_count
        __props__.__dict__["host_shape_name"] = host_shape_name
        __props__.__dict__["is_billing_continuation_in_progress"] = is_billing_continuation_in_progress
        __props__.__dict__["is_billing_swapping_in_progress"] = is_billing_swapping_in_progress
        __props__.__dict__["next_commitment"] = next_commitment
        __props__.__dict__["next_sku"] = next_sku
        __props__.__dict__["non_upgraded_esxi_host_id"] = non_upgraded_esxi_host_id
        __props__.__dict__["replacement_esxi_host_id"] = replacement_esxi_host_id
        __props__.__dict__["sddc_id"] = sddc_id
        __props__.__dict__["state"] = state
        __props__.__dict__["swap_billing_host_id"] = swap_billing_host_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["upgraded_replacement_esxi_host_id"] = upgraded_replacement_esxi_host_id
        __props__.__dict__["vmware_software_version"] = vmware_software_version
        return EsxiHost(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="billingContractEndDate")
    def billing_contract_end_date(self) -> pulumi.Output[str]:
        """
        Current billing cycle end date. If the value in `currentCommitment` and `nextCommitment` are different, the value specified in `nextCommitment` becomes the new `currentCommitment` when the `contractEndDate` is reached. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "billing_contract_end_date")

    @property
    @pulumi.getter(name="billingDonorHostId")
    @_utilities.deprecated("""This 'billing_donor_host_id' argument has been deprecated and will be computed only.""")
    def billing_donor_host_id(self) -> pulumi.Output[str]:
        """
        (Optional) (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        """
        return pulumi.get(self, "billing_donor_host_id")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster to add the ESXi host to.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain to create the ESXi host in. If keep empty, for AD-specific Cluster, new ESXi host will be created in the same availability domain; for multi-AD Cluster, new ESXi host will be auto assigned to the next availability domain following evenly distribution strategy.
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter(name="computeInstanceId")
    def compute_instance_id(self) -> pulumi.Output[str]:
        """
        In terms of implementation, an ESXi host is a Compute instance that is configured with the chosen bundle of VMware software. The `computeInstanceId` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that Compute instance.
        """
        return pulumi.get(self, "compute_instance_id")

    @property
    @pulumi.getter(name="currentCommitment")
    def current_commitment(self) -> pulumi.Output[str]:
        """
        The billing option currently used by the ESXi host. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "current_commitment")

    @property
    @pulumi.getter(name="currentSku")
    @_utilities.deprecated("""The 'current_sku' field has been deprecated. It is no longer supported.""")
    def current_sku(self) -> pulumi.Output[str]:
        """
        (Optional) The billing option currently used by the ESXi host. It is only effective during resource creation. Changes to its value after creation will be ignored. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus). **Deprecated**. Please use `current_commitment` instead.
        """
        return pulumi.get(self, "current_sku")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A descriptive name for the ESXi host. It's changeable. Esxi Host name requirements are 1-16 character length limit, Must start with a letter,  Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the Cluster.

        If this attribute is not specified, the Cluster's `instanceDisplayNamePrefix` attribute is used to name and incrementally number the ESXi host. For example, if you're creating the fourth ESXi host in the Cluster, and `instanceDisplayNamePrefix` is `MyCluster`, the host's display name is `MyCluster-4`.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> pulumi.Output[str]:
        """
        (Updatable) The ESXi software bundle to install on the ESXi host.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "esxi_software_version")

    @property
    @pulumi.getter(name="failedEsxiHostId")
    @_utilities.deprecated("""This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""")
    def failed_esxi_host_id(self) -> pulumi.Output[str]:
        """
        (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is failed. This is an optional parameter. If this parameter is specified, a new ESXi host will be created to replace the failed one, and the `failedEsxiHostId` field will be updated in the newly created Esxi host.
        """
        return pulumi.get(self, "failed_esxi_host_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gracePeriodEndDate")
    def grace_period_end_date(self) -> pulumi.Output[str]:
        """
        The date and time when the new esxi host should start billing cycle. [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2021-07-25T21:10:29.600Z`
        """
        return pulumi.get(self, "grace_period_end_date")

    @property
    @pulumi.getter(name="hostOcpuCount")
    def host_ocpu_count(self) -> pulumi.Output[float]:
        """
        The OCPU count of the ESXi host.
        """
        return pulumi.get(self, "host_ocpu_count")

    @property
    @pulumi.getter(name="hostShapeName")
    def host_shape_name(self) -> pulumi.Output[str]:
        """
        The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "host_shape_name")

    @property
    @pulumi.getter(name="isBillingContinuationInProgress")
    def is_billing_continuation_in_progress(self) -> pulumi.Output[bool]:
        """
        Indicates whether this host is in the progress of billing continuation.
        """
        return pulumi.get(self, "is_billing_continuation_in_progress")

    @property
    @pulumi.getter(name="isBillingSwappingInProgress")
    def is_billing_swapping_in_progress(self) -> pulumi.Output[bool]:
        """
        Indicates whether this host is in the progress of swapping billing.
        """
        return pulumi.get(self, "is_billing_swapping_in_progress")

    @property
    @pulumi.getter(name="nextCommitment")
    def next_commitment(self) -> pulumi.Output[str]:
        """
        The billing option to switch to after the current billing cycle ends. If `nextCommitment` is null or empty, `currentCommitment` continues to the next billing cycle. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "next_commitment")

    @property
    @pulumi.getter(name="nextSku")
    @_utilities.deprecated("""The 'next_sku' field has been deprecated. It is no longer supported.""")
    def next_sku(self) -> pulumi.Output[str]:
        return pulumi.get(self, "next_sku")

    @property
    @pulumi.getter(name="nonUpgradedEsxiHostId")
    @_utilities.deprecated("""This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""")
    def non_upgraded_esxi_host_id(self) -> pulumi.Output[str]:
        """
        (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded. This is an optional parameter. If this parameter is specified, an ESXi host with the new software version is created to replace the original one, and the `nonUpgradedEsxiHostId` field is updated in the newly created Esxi host. See [Upgrading VMware Software](https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/upgrade.htm) for more information.
        """
        return pulumi.get(self, "non_upgraded_esxi_host_id")

    @property
    @pulumi.getter(name="replacementEsxiHostId")
    def replacement_esxi_host_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the esxi host that is newly created to replace the failed node.
        """
        return pulumi.get(self, "replacement_esxi_host_id")

    @property
    @pulumi.getter(name="sddcId")
    @_utilities.deprecated("""The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""")
    def sddc_id(self) -> pulumi.Output[Optional[str]]:
        """
        (Optional) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC to add the ESXi host to. This field has been deprecated. Please use `cluster_id` instead. Either `sddc_id` or `cluster_id` must be configured for `Ocvp.EsxiHost` resource.  **Deprecated**. Please use `cluster_id` instead.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sddc_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the ESXi host.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="swapBillingHostId")
    def swap_billing_host_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the active ESXi Host to swap billing with current host.
        """
        return pulumi.get(self, "swap_billing_host_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the ESXi host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the ESXi host was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradedReplacementEsxiHostId")
    def upgraded_replacement_esxi_host_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is newly created to upgrade the original host.
        """
        return pulumi.get(self, "upgraded_replacement_esxi_host_id")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> pulumi.Output[str]:
        """
        The version of VMware software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        return pulumi.get(self, "vmware_software_version")

