# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEnterpriseManagerBridgesResult',
    'AwaitableGetEnterpriseManagerBridgesResult',
    'get_enterprise_manager_bridges',
    'get_enterprise_manager_bridges_output',
]

@pulumi.output_type
class GetEnterpriseManagerBridgesResult:
    """
    A collection of values returned by getEnterpriseManagerBridges.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, display_name=None, enterprise_manager_bridge_collections=None, filters=None, id=None, states=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enterprise_manager_bridge_collections and not isinstance(enterprise_manager_bridge_collections, list):
            raise TypeError("Expected argument 'enterprise_manager_bridge_collections' to be a list")
        pulumi.set(__self__, "enterprise_manager_bridge_collections", enterprise_manager_bridge_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Compartment identifier of the Enterprise Manager bridge
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        User-friedly name of Enterprise Manager Bridge that does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enterpriseManagerBridgeCollections")
    def enterprise_manager_bridge_collections(self) -> Sequence['outputs.GetEnterpriseManagerBridgesEnterpriseManagerBridgeCollectionResult']:
        """
        The list of enterprise_manager_bridge_collection.
        """
        return pulumi.get(self, "enterprise_manager_bridge_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEnterpriseManagerBridgesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Enterprise Manager bridge identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def states(self) -> Optional[Sequence[str]]:
        """
        The current state of the Enterprise Manager bridge.
        """
        return pulumi.get(self, "states")


class AwaitableGetEnterpriseManagerBridgesResult(GetEnterpriseManagerBridgesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnterpriseManagerBridgesResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            enterprise_manager_bridge_collections=self.enterprise_manager_bridge_collections,
            filters=self.filters,
            id=self.id,
            states=self.states)


def get_enterprise_manager_bridges(compartment_id: Optional[str] = None,
                                   compartment_id_in_subtree: Optional[bool] = None,
                                   display_name: Optional[str] = None,
                                   filters: Optional[Sequence[pulumi.InputType['GetEnterpriseManagerBridgesFilterArgs']]] = None,
                                   id: Optional[str] = None,
                                   states: Optional[Sequence[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnterpriseManagerBridgesResult:
    """
    This data source provides the list of Enterprise Manager Bridges in Oracle Cloud Infrastructure Opsi service.

    Gets a list of Ops Insights Enterprise Manager bridges. Either compartmentId or id must be specified.
    When both compartmentId and compartmentIdInSubtree are specified, a list of bridges in that compartment and in all sub-compartments will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_enterprise_manager_bridges = oci.Opsi.get_enterprise_manager_bridges(compartment_id=compartment_id,
        compartment_id_in_subtree=enterprise_manager_bridge_compartment_id_in_subtree,
        display_name=enterprise_manager_bridge_display_name,
        id=enterprise_manager_bridge_id,
        states=enterprise_manager_bridge_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param str display_name: A filter to return only resources that match the entire display name.
    :param str id: Unique Enterprise Manager bridge identifier
    :param Sequence[str] states: Lifecycle states
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['states'] = states
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getEnterpriseManagerBridges:getEnterpriseManagerBridges', __args__, opts=opts, typ=GetEnterpriseManagerBridgesResult).value

    return AwaitableGetEnterpriseManagerBridgesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        enterprise_manager_bridge_collections=pulumi.get(__ret__, 'enterprise_manager_bridge_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        states=pulumi.get(__ret__, 'states'))


@_utilities.lift_output_func(get_enterprise_manager_bridges)
def get_enterprise_manager_bridges_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                          compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                          display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetEnterpriseManagerBridgesFilterArgs']]]]] = None,
                                          id: Optional[pulumi.Input[Optional[str]]] = None,
                                          states: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnterpriseManagerBridgesResult]:
    """
    This data source provides the list of Enterprise Manager Bridges in Oracle Cloud Infrastructure Opsi service.

    Gets a list of Ops Insights Enterprise Manager bridges. Either compartmentId or id must be specified.
    When both compartmentId and compartmentIdInSubtree are specified, a list of bridges in that compartment and in all sub-compartments will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_enterprise_manager_bridges = oci.Opsi.get_enterprise_manager_bridges(compartment_id=compartment_id,
        compartment_id_in_subtree=enterprise_manager_bridge_compartment_id_in_subtree,
        display_name=enterprise_manager_bridge_display_name,
        id=enterprise_manager_bridge_id,
        states=enterprise_manager_bridge_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param str display_name: A filter to return only resources that match the entire display name.
    :param str id: Unique Enterprise Manager bridge identifier
    :param Sequence[str] states: Lifecycle states
    """
    ...
