# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetOperationsInsightsWarehouseUserResult',
    'AwaitableGetOperationsInsightsWarehouseUserResult',
    'get_operations_insights_warehouse_user',
    'get_operations_insights_warehouse_user_output',
]

@pulumi.output_type
class GetOperationsInsightsWarehouseUserResult:
    """
    A collection of values returned by getOperationsInsightsWarehouseUser.
    """
    def __init__(__self__, compartment_id=None, connection_password=None, defined_tags=None, freeform_tags=None, id=None, is_awr_data_access=None, is_em_data_access=None, is_opsi_data_access=None, lifecycle_details=None, name=None, operations_insights_warehouse_id=None, operations_insights_warehouse_user_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_password and not isinstance(connection_password, str):
            raise TypeError("Expected argument 'connection_password' to be a str")
        pulumi.set(__self__, "connection_password", connection_password)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_awr_data_access and not isinstance(is_awr_data_access, bool):
            raise TypeError("Expected argument 'is_awr_data_access' to be a bool")
        pulumi.set(__self__, "is_awr_data_access", is_awr_data_access)
        if is_em_data_access and not isinstance(is_em_data_access, bool):
            raise TypeError("Expected argument 'is_em_data_access' to be a bool")
        pulumi.set(__self__, "is_em_data_access", is_em_data_access)
        if is_opsi_data_access and not isinstance(is_opsi_data_access, bool):
            raise TypeError("Expected argument 'is_opsi_data_access' to be a bool")
        pulumi.set(__self__, "is_opsi_data_access", is_opsi_data_access)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operations_insights_warehouse_id and not isinstance(operations_insights_warehouse_id, str):
            raise TypeError("Expected argument 'operations_insights_warehouse_id' to be a str")
        pulumi.set(__self__, "operations_insights_warehouse_id", operations_insights_warehouse_id)
        if operations_insights_warehouse_user_id and not isinstance(operations_insights_warehouse_user_id, str):
            raise TypeError("Expected argument 'operations_insights_warehouse_user_id' to be a str")
        pulumi.set(__self__, "operations_insights_warehouse_user_id", operations_insights_warehouse_user_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionPassword")
    def connection_password(self) -> str:
        """
        User provided connection password for the AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        """
        return pulumi.get(self, "connection_password")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Hub User OCID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAwrDataAccess")
    def is_awr_data_access(self) -> bool:
        """
        Indicate whether user has access to AWR data.
        """
        return pulumi.get(self, "is_awr_data_access")

    @property
    @pulumi.getter(name="isEmDataAccess")
    def is_em_data_access(self) -> bool:
        """
        Indicate whether user has access to EM data.
        """
        return pulumi.get(self, "is_em_data_access")

    @property
    @pulumi.getter(name="isOpsiDataAccess")
    def is_opsi_data_access(self) -> bool:
        """
        Indicate whether user has access to OPSI data.
        """
        return pulumi.get(self, "is_opsi_data_access")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Username for schema which would have access to AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationsInsightsWarehouseId")
    def operations_insights_warehouse_id(self) -> str:
        """
        OPSI Warehouse OCID
        """
        return pulumi.get(self, "operations_insights_warehouse_id")

    @property
    @pulumi.getter(name="operationsInsightsWarehouseUserId")
    def operations_insights_warehouse_user_id(self) -> str:
        return pulumi.get(self, "operations_insights_warehouse_user_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Possible lifecycle states
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOperationsInsightsWarehouseUserResult(GetOperationsInsightsWarehouseUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOperationsInsightsWarehouseUserResult(
            compartment_id=self.compartment_id,
            connection_password=self.connection_password,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_awr_data_access=self.is_awr_data_access,
            is_em_data_access=self.is_em_data_access,
            is_opsi_data_access=self.is_opsi_data_access,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            operations_insights_warehouse_id=self.operations_insights_warehouse_id,
            operations_insights_warehouse_user_id=self.operations_insights_warehouse_user_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_operations_insights_warehouse_user(operations_insights_warehouse_user_id: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOperationsInsightsWarehouseUserResult:
    """
    This data source provides details about a specific Operations Insights Warehouse User resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of an Operations Insights Warehouse User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operations_insights_warehouse_user = oci.Opsi.get_operations_insights_warehouse_user(operations_insights_warehouse_user_id=test_operations_insights_warehouse_user_oci_opsi_operations_insights_warehouse_user["id"])
    ```


    :param str operations_insights_warehouse_user_id: Unique Operations Insights Warehouse User identifier
    """
    __args__ = dict()
    __args__['operationsInsightsWarehouseUserId'] = operations_insights_warehouse_user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getOperationsInsightsWarehouseUser:getOperationsInsightsWarehouseUser', __args__, opts=opts, typ=GetOperationsInsightsWarehouseUserResult).value

    return AwaitableGetOperationsInsightsWarehouseUserResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_password=pulumi.get(__ret__, 'connection_password'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_awr_data_access=pulumi.get(__ret__, 'is_awr_data_access'),
        is_em_data_access=pulumi.get(__ret__, 'is_em_data_access'),
        is_opsi_data_access=pulumi.get(__ret__, 'is_opsi_data_access'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        operations_insights_warehouse_id=pulumi.get(__ret__, 'operations_insights_warehouse_id'),
        operations_insights_warehouse_user_id=pulumi.get(__ret__, 'operations_insights_warehouse_user_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_operations_insights_warehouse_user)
def get_operations_insights_warehouse_user_output(operations_insights_warehouse_user_id: Optional[pulumi.Input[str]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOperationsInsightsWarehouseUserResult]:
    """
    This data source provides details about a specific Operations Insights Warehouse User resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of an Operations Insights Warehouse User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operations_insights_warehouse_user = oci.Opsi.get_operations_insights_warehouse_user(operations_insights_warehouse_user_id=test_operations_insights_warehouse_user_oci_opsi_operations_insights_warehouse_user["id"])
    ```


    :param str operations_insights_warehouse_user_id: Unique Operations Insights Warehouse User identifier
    """
    ...
