# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetFuturesLedgerReq(BaseModel):
    """
    GetFuturesLedgerReq

    Attributes:
        currency (str): Currency of transaction history, XBT or USDT
        type (str): Type RealisedPNL-Realised profit and loss, Deposit-Deposit, Withdrawal-withdraw, Transferin-Transfer in, TransferOut-Transfer out
        offset (int): Start offset. Generally, the only attribute of the last returned result of the previous request is used, and the first page is returned by default
        forward (bool): This parameter functions to judge whether the lookup is forward or not. True means “yes” and False means “no”. This parameter is set as true by default
        max_count (int): Displayed size per page. The default size is 50
        start_at (int): Start time (milisecond)
        end_at (int): End time (milisecond)
    """

    currency: Optional[str] = Field(
        default=None,
        description="Currency of transaction history, XBT or USDT")
    type: Optional[str] = Field(
        default=None,
        description=
        "Type RealisedPNL-Realised profit and loss, Deposit-Deposit, Withdrawal-withdraw, Transferin-Transfer in, TransferOut-Transfer out"
    )
    offset: Optional[int] = Field(
        default=None,
        description=
        "Start offset. Generally, the only attribute of the last returned result of the previous request is used, and the first page is returned by default"
    )
    forward: Optional[bool] = Field(
        default=True,
        description=
        "This parameter functions to judge whether the lookup is forward or not. True means “yes” and False means “no”. This parameter is set as true by default"
    )
    max_count: Optional[int] = Field(
        default=50,
        description="Displayed size per page. The default size is 50",
        alias="maxCount")
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milisecond)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milisecond)",
                                  alias="endAt")

    __properties: ClassVar[List[str]] = [
        "currency", "type", "offset", "forward", "maxCount", "startAt", "endAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetFuturesLedgerReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetFuturesLedgerReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "type":
            obj.get("type"),
            "offset":
            obj.get("offset"),
            "forward":
            obj.get("forward") if obj.get("forward") is not None else True,
            "maxCount":
            obj.get("maxCount") if obj.get("maxCount") is not None else 50,
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt")
        })
        return _obj


class GetFuturesLedgerReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetFuturesLedgerReqBuilder:
        """
        Currency of transaction history, XBT or USDT
        """
        self.obj['currency'] = value
        return self

    def set_type(self, value: str) -> GetFuturesLedgerReqBuilder:
        """
        Type RealisedPNL-Realised profit and loss, Deposit-Deposit, Withdrawal-withdraw, Transferin-Transfer in, TransferOut-Transfer out
        """
        self.obj['type'] = value
        return self

    def set_offset(self, value: int) -> GetFuturesLedgerReqBuilder:
        """
        Start offset. Generally, the only attribute of the last returned result of the previous request is used, and the first page is returned by default
        """
        self.obj['offset'] = value
        return self

    def set_forward(self, value: bool) -> GetFuturesLedgerReqBuilder:
        """
        This parameter functions to judge whether the lookup is forward or not. True means “yes” and False means “no”. This parameter is set as true by default
        """
        self.obj['forward'] = value
        return self

    def set_max_count(self, value: int) -> GetFuturesLedgerReqBuilder:
        """
        Displayed size per page. The default size is 50
        """
        self.obj['maxCount'] = value
        return self

    def set_start_at(self, value: int) -> GetFuturesLedgerReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetFuturesLedgerReqBuilder:
        """
        End time (milisecond)
        """
        self.obj['endAt'] = value
        return self

    def build(self) -> GetFuturesLedgerReq:
        return GetFuturesLedgerReq(**self.obj)
