# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_isolated_margin_account_assets import GetIsolatedMarginAccountAssets
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetIsolatedMarginAccountResp(BaseModel, Response):
    """
    GetIsolatedMarginAccountResp

    Attributes:
        total_asset_of_quote_currency (str): Total Assets in Quote Currency
        total_liability_of_quote_currency (str): Total Liability in Quote Currency
        timestamp (int): timestamp
        assets (list[GetIsolatedMarginAccountAssets]): 
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    total_asset_of_quote_currency: Optional[str] = Field(
        default=None,
        description="Total Assets in Quote Currency",
        alias="totalAssetOfQuoteCurrency")
    total_liability_of_quote_currency: Optional[str] = Field(
        default=None,
        description="Total Liability in Quote Currency",
        alias="totalLiabilityOfQuoteCurrency")
    timestamp: Optional[int] = Field(default=None, description="timestamp")
    assets: Optional[List[GetIsolatedMarginAccountAssets]] = None

    __properties: ClassVar[List[str]] = [
        "totalAssetOfQuoteCurrency", "totalLiabilityOfQuoteCurrency",
        "timestamp", "assets"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[GetIsolatedMarginAccountResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assets (list)
        _items = []
        if self.assets:
            for _item_assets in self.assets:
                if _item_assets:
                    _items.append(_item_assets.to_dict())
            _dict['assets'] = _items
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[GetIsolatedMarginAccountResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totalAssetOfQuoteCurrency":
            obj.get("totalAssetOfQuoteCurrency"),
            "totalLiabilityOfQuoteCurrency":
            obj.get("totalLiabilityOfQuoteCurrency"),
            "timestamp":
            obj.get("timestamp"),
            "assets": [
                GetIsolatedMarginAccountAssets.from_dict(_item)
                for _item in obj["assets"]
            ] if obj.get("assets") is not None else None
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
