# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetMarginAccountDetailAccounts(BaseModel):
    """
    GetMarginAccountDetailAccounts

    Attributes:
        currency (str): Currency
        total_balance (str): Total funds in the account
        available_balance (str): Available funds in the account
        hold_balance (str): Funds on hold in the account
        liability (str): Total liabilities
        max_borrow_size (str): Available size to borrow
    """

    currency: Optional[str] = Field(default=None, description="Currency")
    total_balance: Optional[str] = Field(
        default=None,
        description="Total funds in the account",
        alias="totalBalance")
    available_balance: Optional[str] = Field(
        default=None,
        description="Available funds in the account",
        alias="availableBalance")
    hold_balance: Optional[str] = Field(
        default=None,
        description="Funds on hold in the account",
        alias="holdBalance")
    liability: Optional[str] = Field(default=None,
                                     description="Total liabilities")
    max_borrow_size: Optional[str] = Field(
        default=None,
        description="Available size to borrow",
        alias="maxBorrowSize")

    __properties: ClassVar[List[str]] = [
        "currency", "totalBalance", "availableBalance", "holdBalance",
        "liability", "maxBorrowSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[GetMarginAccountDetailAccounts]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[GetMarginAccountDetailAccounts]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "totalBalance":
            obj.get("totalBalance"),
            "availableBalance":
            obj.get("availableBalance"),
            "holdBalance":
            obj.get("holdBalance"),
            "liability":
            obj.get("liability"),
            "maxBorrowSize":
            obj.get("maxBorrowSize")
        })
        return _obj
