# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetMarginHfLedgerData(BaseModel):
    """
    GetMarginHfLedgerData

    Attributes:
        id (int): 
        currency (str): currency
        amount (str): Change in funds balance
        fee (str): Deposit or withdrawal fee
        balance (str): Total balance of funds after change
        account_type (str): Master account type TRADE_HF
        biz_type (str): Trnasaction type，such as TRANSFER, TRADE_EXCHANGE, etc.
        direction (str): Direction of transfer( out or in)
        created_at (int): Ledger creation time
        context (str): Core transaction parameter
        tax (str): 
    """

    id: Optional[int] = None
    currency: Optional[str] = Field(default=None, description="currency")
    amount: Optional[str] = Field(default=None,
                                  description="Change in funds balance")
    fee: Optional[str] = Field(default=None,
                               description="Deposit or withdrawal fee")
    balance: Optional[str] = Field(
        default=None, description="Total balance of funds after change")
    account_type: Optional[str] = Field(
        default=None,
        description="Master account type TRADE_HF",
        alias="accountType")
    biz_type: Optional[str] = Field(
        default=None,
        description="Trnasaction type，such as TRANSFER, TRADE_EXCHANGE, etc.",
        alias="bizType")
    direction: Optional[str] = Field(
        default=None, description="Direction of transfer( out or in)")
    created_at: Optional[int] = Field(default=None,
                                      description="Ledger creation time",
                                      alias="createdAt")
    context: Optional[str] = Field(default=None,
                                   description="Core transaction parameter")
    tax: Optional[str] = None

    __properties: ClassVar[List[str]] = [
        "id", "currency", "amount", "fee", "balance", "accountType", "bizType",
        "direction", "createdAt", "context", "tax"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetMarginHfLedgerData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetMarginHfLedgerData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "currency": obj.get("currency"),
            "amount": obj.get("amount"),
            "fee": obj.get("fee"),
            "balance": obj.get("balance"),
            "accountType": obj.get("accountType"),
            "bizType": obj.get("bizType"),
            "direction": obj.get("direction"),
            "createdAt": obj.get("createdAt"),
            "context": obj.get("context"),
            "tax": obj.get("tax")
        })
        return _obj
