# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSpotHfLedgerData(BaseModel):
    """
    GetSpotHfLedgerData

    Attributes:
        id (str): Unique id
        currency (str): currency
        amount (str): Change in funds balance
        fee (str): Deposit or withdrawal fee
        tax (str): 
        balance (str): Total balance of funds after change
        account_type (str): Master account type TRADE_HF
        biz_type (str): Trnasaction type，such as TRANSFER, TRADE_EXCHANGE, etc.
        direction (DirectionEnum): Direction of transfer( out or in)
        created_at (str): Created time
        context (str): Core transaction parameter
    """

    class DirectionEnum(Enum):
        """
        Attributes:
            IN_: 
            OUT: 
        """
        IN_ = 'in'
        OUT = 'out'

    id: Optional[str] = Field(default=None, description="Unique id")
    currency: Optional[str] = Field(default=None, description="currency")
    amount: Optional[str] = Field(default=None,
                                  description="Change in funds balance")
    fee: Optional[str] = Field(default=None,
                               description="Deposit or withdrawal fee")
    tax: Optional[str] = None
    balance: Optional[str] = Field(
        default=None, description="Total balance of funds after change")
    account_type: Optional[str] = Field(
        default=None,
        description="Master account type TRADE_HF",
        alias="accountType")
    biz_type: Optional[str] = Field(
        default=None,
        description="Trnasaction type，such as TRANSFER, TRADE_EXCHANGE, etc.",
        alias="bizType")
    direction: Optional[DirectionEnum] = Field(
        default=None, description="Direction of transfer( out or in)")
    created_at: Optional[str] = Field(default=None,
                                      description="Created time",
                                      alias="createdAt")
    context: Optional[str] = Field(default=None,
                                   description="Core transaction parameter")

    __properties: ClassVar[List[str]] = [
        "id", "currency", "amount", "fee", "tax", "balance", "accountType",
        "bizType", "direction", "createdAt", "context"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSpotHfLedgerData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetSpotHfLedgerData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "currency": obj.get("currency"),
            "amount": obj.get("amount"),
            "fee": obj.get("fee"),
            "tax": obj.get("tax"),
            "balance": obj.get("balance"),
            "accountType": obj.get("accountType"),
            "bizType": obj.get("bizType"),
            "direction": obj.get("direction"),
            "createdAt": obj.get("createdAt"),
            "context": obj.get("context")
        })
        return _obj
