# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class AddDepositAddressV3Req(BaseModel):
    """
    AddDepositAddressV3Req

    Attributes:
        currency (str): currency
        chain (str): The chainId of currency, e.g. The available value for USDT are OMNI, ERC20, TRC20, default is ERC20. The available value for BTC are Native, Segwit, TRC20, the parameters are bech32, btc, trx, default is Native. This only apply for multi-chain currency, and there is no need for single chain currency.
        to (ToEnum): Deposit account type: main (funding account), trade (spot trading account), the default is main
        amount (str): Deposit amount. This parameter is only used when applying for invoices on the Lightning Network. This parameter is invalid if it is not passed through the Lightning Network.
    """

    class ToEnum(Enum):
        """
        Attributes:
            MAIN: 
            TRADE: 
        """
        MAIN = 'main'
        TRADE = 'trade'

    currency: Optional[str] = Field(default=None, description="currency")
    chain: Optional[str] = Field(
        default='eth',
        description=
        "The chainId of currency, e.g. The available value for USDT are OMNI, ERC20, TRC20, default is ERC20. The available value for BTC are Native, Segwit, TRC20, the parameters are bech32, btc, trx, default is Native. This only apply for multi-chain currency, and there is no need for single chain currency."
    )
    to: Optional[ToEnum] = Field(
        default=ToEnum.MAIN,
        description=
        "Deposit account type: main (funding account), trade (spot trading account), the default is main"
    )
    amount: Optional[str] = Field(
        default=None,
        description=
        "Deposit amount. This parameter is only used when applying for invoices on the Lightning Network. This parameter is invalid if it is not passed through the Lightning Network."
    )

    __properties: ClassVar[List[str]] = ["currency", "chain", "to", "amount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AddDepositAddressV3Req]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[AddDepositAddressV3Req]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "chain":
            obj.get("chain") if obj.get("chain") is not None else 'eth',
            "to":
            obj.get("to") if obj.get("to") is not None else
            AddDepositAddressV3Req.ToEnum.MAIN,
            "amount":
            obj.get("amount")
        })
        return _obj


class AddDepositAddressV3ReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> AddDepositAddressV3ReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_chain(self, value: str) -> AddDepositAddressV3ReqBuilder:
        """
        The chainId of currency, e.g. The available value for USDT are OMNI, ERC20, TRC20, default is ERC20. The available value for BTC are Native, Segwit, TRC20, the parameters are bech32, btc, trx, default is Native. This only apply for multi-chain currency, and there is no need for single chain currency.
        """
        self.obj['chain'] = value
        return self

    def set_to(
            self, value: AddDepositAddressV3Req.ToEnum
    ) -> AddDepositAddressV3ReqBuilder:
        """
        Deposit account type: main (funding account), trade (spot trading account), the default is main
        """
        self.obj['to'] = value
        return self

    def set_amount(self, value: str) -> AddDepositAddressV3ReqBuilder:
        """
        Deposit amount. This parameter is only used when applying for invoices on the Lightning Network. This parameter is invalid if it is not passed through the Lightning Network.
        """
        self.obj['amount'] = value
        return self

    def build(self) -> AddDepositAddressV3Req:
        return AddDepositAddressV3Req(**self.obj)
