# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetDepositAddressV3Data(BaseModel):
    """
    GetDepositAddressV3Data

    Attributes:
        address (str): Deposit address
        memo (str): Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to the KuCoin, you need to fill in memo(tag). If you do not fill memo (tag), your deposit may not be available, please be cautious.
        chain_id (str): The chainId of currency
        to (str): Deposit account type: main (funding account), trade (spot trading account)
        expiration_date (int): Expiration time, Lightning network expiration time, non-Lightning network this field is invalid
        currency (str): currency
        contract_address (str): The token contract address.
        chain_name (str): The chainName of currency
    """

    address: Optional[str] = Field(default=None, description="Deposit address")
    memo: Optional[str] = Field(
        default=None,
        description=
        "Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to the KuCoin, you need to fill in memo(tag). If you do not fill memo (tag), your deposit may not be available, please be cautious."
    )
    chain_id: Optional[str] = Field(default=None,
                                    description="The chainId of currency",
                                    alias="chainId")
    to: Optional[str] = Field(
        default=None,
        description=
        "Deposit account type: main (funding account), trade (spot trading account)"
    )
    expiration_date: Optional[int] = Field(
        default=None,
        description=
        "Expiration time, Lightning network expiration time, non-Lightning network this field is invalid",
        alias="expirationDate")
    currency: Optional[str] = Field(default=None, description="currency")
    contract_address: Optional[str] = Field(
        default=None,
        description="The token contract address.",
        alias="contractAddress")
    chain_name: Optional[str] = Field(default=None,
                                      description="The chainName of currency",
                                      alias="chainName")

    __properties: ClassVar[List[str]] = [
        "address", "memo", "chainId", "to", "expirationDate", "currency",
        "contractAddress", "chainName"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetDepositAddressV3Data]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetDepositAddressV3Data]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "memo": obj.get("memo"),
            "chainId": obj.get("chainId"),
            "to": obj.get("to"),
            "expirationDate": obj.get("expirationDate"),
            "currency": obj.get("currency"),
            "contractAddress": obj.get("contractAddress"),
            "chainName": obj.get("chainName")
        })
        return _obj
