# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated


class GetDepositHistoryReq(BaseModel):
    """
    GetDepositHistoryReq

    Attributes:
        currency (str): currency
        status (StatusEnum): Status. Available value: PROCESSING, SUCCESS, and FAILURE
        start_at (int): Start time (milisecond)
        end_at (int): End time (milisecond)
        current_page (int): Current request page.
        page_size (int): Number of results per request. Minimum is 10, maximum is 500.
    """

    class StatusEnum(Enum):
        """
        Attributes:
            PROCESSING: 
            SUCCESS: 
            FAILURE: 
        """
        PROCESSING = 'PROCESSING'
        SUCCESS = 'SUCCESS'
        FAILURE = 'FAILURE'

    currency: Optional[str] = Field(default=None, description="currency")
    status: Optional[StatusEnum] = Field(
        default=None,
        description="Status. Available value: PROCESSING, SUCCESS, and FAILURE"
    )
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milisecond)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milisecond)",
                                  alias="endAt")
    current_page: Optional[int] = Field(default=None,
                                        description="Current request page.",
                                        alias="currentPage")
    page_size: Optional[Annotated[
        int, Field(le=500, strict=True, ge=10)]] = Field(
            default=50,
            description=
            "Number of results per request. Minimum is 10, maximum is 500.",
            alias="pageSize")

    __properties: ClassVar[List[str]] = [
        "currency", "status", "startAt", "endAt", "currentPage", "pageSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetDepositHistoryReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetDepositHistoryReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "status":
            obj.get("status"),
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt"),
            "currentPage":
            obj.get("currentPage"),
            "pageSize":
            obj.get("pageSize") if obj.get("pageSize") is not None else 50
        })
        return _obj


class GetDepositHistoryReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetDepositHistoryReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_status(
            self, value: GetDepositHistoryReq.StatusEnum
    ) -> GetDepositHistoryReqBuilder:
        """
        Status. Available value: PROCESSING, SUCCESS, and FAILURE
        """
        self.obj['status'] = value
        return self

    def set_start_at(self, value: int) -> GetDepositHistoryReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetDepositHistoryReqBuilder:
        """
        End time (milisecond)
        """
        self.obj['endAt'] = value
        return self

    def set_current_page(self, value: int) -> GetDepositHistoryReqBuilder:
        """
        Current request page.
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(self, value: int) -> GetDepositHistoryReqBuilder:
        """
        Number of results per request. Minimum is 10, maximum is 500.
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetDepositHistoryReq:
        return GetDepositHistoryReq(**self.obj)
