# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_get_basic_fee_req import GetBasicFeeReq
from .model_get_basic_fee_resp import GetBasicFeeResp
from .model_get_futures_actual_fee_req import GetFuturesActualFeeReq
from .model_get_futures_actual_fee_resp import GetFuturesActualFeeResp
from .model_get_spot_actual_fee_req import GetSpotActualFeeReq
from .model_get_spot_actual_fee_resp import GetSpotActualFeeResp


class FeeAPI(ABC):

    @abstractmethod
    def get_basic_fee(self, req: GetBasicFeeReq,
                      **kwargs: Any) -> GetBasicFeeResp:
        """
        summary: Get Basic Fee - Spot/Margin
        description: This interface is for the spot/margin basic fee rate of users
        documentation: https://www.kucoin.com/docs-new/api-3470149
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 3       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_spot_actual_fee(self, req: GetSpotActualFeeReq,
                            **kwargs: Any) -> GetSpotActualFeeResp:
        """
        summary: Get Actual Fee - Spot/Margin
        description: This interface is for the actual fee rate of the trading pair. You can inquire about fee rates of 10 trading pairs each time at most. The fee rate of your sub-account is the same as that of the master account.
        documentation: https://www.kucoin.com/docs-new/api-3470150
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 3       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_futures_actual_fee(self, req: GetFuturesActualFeeReq,
                               **kwargs: Any) -> GetFuturesActualFeeResp:
        """
        summary: Get Actual Fee - Futures
        description: This interface is for the actual futures fee rate of the trading pair. The fee rate of your sub-account is the same as that of the master account.
        documentation: https://www.kucoin.com/docs-new/api-3470151
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 3       |
        +---------------------+---------+
        """
        pass


class FeeAPIImpl(FeeAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def get_basic_fee(self, req: GetBasicFeeReq,
                      **kwargs: Any) -> GetBasicFeeResp:
        return self.transport.call("spot", False, "GET", "/api/v1/base-fee",
                                   req, GetBasicFeeResp(), False, **kwargs)

    def get_spot_actual_fee(self, req: GetSpotActualFeeReq,
                            **kwargs: Any) -> GetSpotActualFeeResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/trade-fees", req,
                                   GetSpotActualFeeResp(), False, **kwargs)

    def get_futures_actual_fee(self, req: GetFuturesActualFeeReq,
                               **kwargs: Any) -> GetFuturesActualFeeResp:
        return self.transport.call("futures", False, "get",
                                   "/api/v1/trade-fees", req,
                                   GetFuturesActualFeeResp(), False, **kwargs)
