# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_futures_sub_account_list_v2_accounts import GetFuturesSubAccountListV2Accounts
from .model_get_futures_sub_account_list_v2_summary import GetFuturesSubAccountListV2Summary
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetFuturesSubAccountListV2Resp(BaseModel, Response):
    """
    GetFuturesSubAccountListV2Resp

    Attributes:
        summary (GetFuturesSubAccountListV2Summary): 
        accounts (list[GetFuturesSubAccountListV2Accounts]): Account List
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    summary: Optional[GetFuturesSubAccountListV2Summary] = None
    accounts: Optional[List[GetFuturesSubAccountListV2Accounts]] = Field(
        default=None, description="Account List")

    __properties: ClassVar[List[str]] = ["summary", "accounts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[GetFuturesSubAccountListV2Resp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of summary
        if self.summary:
            _dict['summary'] = self.summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in accounts (list)
        _items = []
        if self.accounts:
            for _item_accounts in self.accounts:
                if _item_accounts:
                    _items.append(_item_accounts.to_dict())
            _dict['accounts'] = _items
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[GetFuturesSubAccountListV2Resp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "summary":
            GetFuturesSubAccountListV2Summary.from_dict(obj["summary"])
            if obj.get("summary") is not None else None,
            "accounts": [
                GetFuturesSubAccountListV2Accounts.from_dict(_item)
                for _item in obj["accounts"]
            ] if obj.get("accounts") is not None else None
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
