# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSubAccountApiListReq(BaseModel):
    """
    GetSubAccountApiListReq

    Attributes:
        api_key (str): API-Key
        sub_name (str): Sub-account name.
    """

    api_key: Optional[str] = Field(default=None,
                                   description="API-Key",
                                   alias="apiKey")
    sub_name: Optional[str] = Field(default=None,
                                    description="Sub-account name.",
                                    alias="subName")

    __properties: ClassVar[List[str]] = ["apiKey", "subName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSubAccountApiListReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetSubAccountApiListReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "apiKey": obj.get("apiKey"),
            "subName": obj.get("subName")
        })
        return _obj


class GetSubAccountApiListReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_api_key(self, value: str) -> GetSubAccountApiListReqBuilder:
        """
        API-Key
        """
        self.obj['apiKey'] = value
        return self

    def set_sub_name(self, value: str) -> GetSubAccountApiListReqBuilder:
        """
        Sub-account name.
        """
        self.obj['subName'] = value
        return self

    def build(self) -> GetSubAccountApiListReq:
        return GetSubAccountApiListReq(**self.obj)
