# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class ModifySubAccountApiResp(BaseModel, Response):
    """
    ModifySubAccountApiResp

    Attributes:
        sub_name (str): Sub-account name
        api_key (str): API Key
        permission (str): [Permissions](https://www.kucoin.com/docs-new/doc-338144)
        ip_whitelist (str): IP whitelist
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    sub_name: Optional[str] = Field(default=None,
                                    description="Sub-account name",
                                    alias="subName")
    api_key: Optional[str] = Field(default=None,
                                   description="API Key",
                                   alias="apiKey")
    permission: Optional[str] = Field(
        default=None,
        description="[Permissions](https://www.kucoin.com/docs-new/doc-338144)"
    )
    ip_whitelist: Optional[str] = Field(default=None,
                                        description="IP whitelist",
                                        alias="ipWhitelist")

    __properties: ClassVar[List[str]] = [
        "subName", "apiKey", "permission", "ipWhitelist"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[ModifySubAccountApiResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[ModifySubAccountApiResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subName": obj.get("subName"),
            "apiKey": obj.get("apiKey"),
            "permission": obj.get("permission"),
            "ipWhitelist": obj.get("ipWhitelist")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
