# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_flex_transfer_req import FlexTransferReq
from .model_flex_transfer_resp import FlexTransferResp
from .model_futures_account_transfer_in_req import FuturesAccountTransferInReq
from .model_futures_account_transfer_in_resp import FuturesAccountTransferInResp
from .model_futures_account_transfer_out_req import FuturesAccountTransferOutReq
from .model_futures_account_transfer_out_resp import FuturesAccountTransferOutResp
from .model_get_futures_account_transfer_out_ledger_req import GetFuturesAccountTransferOutLedgerReq
from .model_get_futures_account_transfer_out_ledger_resp import GetFuturesAccountTransferOutLedgerResp
from .model_get_transfer_quotas_req import GetTransferQuotasReq
from .model_get_transfer_quotas_resp import GetTransferQuotasResp
from .model_inner_transfer_req import InnerTransferReq
from .model_inner_transfer_resp import InnerTransferResp
from .model_sub_account_transfer_req import SubAccountTransferReq
from .model_sub_account_transfer_resp import SubAccountTransferResp
from typing_extensions import deprecated


class TransferAPI(ABC):

    @abstractmethod
    def get_transfer_quotas(self, req: GetTransferQuotasReq,
                            **kwargs: Any) -> GetTransferQuotasResp:
        """
        summary: Get Transfer Quotas
        description: This endpoint returns the transferable balance of a specified account.
        documentation: https://www.kucoin.com/docs-new/api-3470148
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | SPOT       |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | GENERAL    |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 20         |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    def flex_transfer(self, req: FlexTransferReq,
                      **kwargs: Any) -> FlexTransferResp:
        """
        summary: Flex Transfer
        description: This interface can be used for transfers between master and sub accounts and inner transfers
        documentation: https://www.kucoin.com/docs-new/api-3470147
        +---------------------+---------------+
        | Extra API Info      | Value         |
        +---------------------+---------------+
        | API-DOMAIN          | SPOT          |
        | API-CHANNEL         | PRIVATE       |
        | API-PERMISSION      | FLEXTRANSFERS |
        | API-RATE-LIMIT-POOL | MANAGEMENT    |
        | API-RATE-LIMIT      | 4             |
        +---------------------+---------------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def sub_account_transfer(self, req: SubAccountTransferReq,
                             **kwargs: Any) -> SubAccountTransferResp:
        """
        summary: SubAccount Transfer
        description: Funds in the main account, trading account and margin account of a Master Account can be transferred to the main account, trading account, futures account and margin account of its Sub-Account. The futures account of both the Master Account and Sub-Account can only accept funds transferred in from the main account, trading account and margin account and cannot transfer out to these accounts.
        documentation: https://www.kucoin.com/docs-new/api-3470301
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | SPOT       |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | SPOT       |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 30         |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def inner_transfer(self, req: InnerTransferReq,
                       **kwargs: Any) -> InnerTransferResp:
        """
        summary: Inner Transfer
        description: This API endpoint can be used to transfer funds between accounts internally. Users can transfer funds between their account free of charge. 
        documentation: https://www.kucoin.com/docs-new/api-3470302
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | SPOT       |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | SPOT       |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 10         |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def futures_account_transfer_out(
            self, req: FuturesAccountTransferOutReq,
            **kwargs: Any) -> FuturesAccountTransferOutResp:
        """
        summary: Futures Account Transfer Out
        description: The amount to be transferred will be deducted from the KuCoin Futures Account. Please ensure that you have sufficient funds in your KuCoin Futures Account, or the transfer will fail.
        documentation: https://www.kucoin.com/docs-new/api-3470303
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | FUTURES    |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | FUTURES    |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 20         |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def futures_account_transfer_in(
            self, req: FuturesAccountTransferInReq,
            **kwargs: Any) -> FuturesAccountTransferInResp:
        """
        summary: Futures Account Transfer In
        description: The amount to be transferred will be deducted from the payAccount. Please ensure that you have sufficient funds in your payAccount Account, or the transfer will fail.
        documentation: https://www.kucoin.com/docs-new/api-3470304
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | FUTURES    |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | FUTURES    |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 20         |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def get_futures_account_transfer_out_ledger(
            self, req: GetFuturesAccountTransferOutLedgerReq,
            **kwargs: Any) -> GetFuturesAccountTransferOutLedgerResp:
        """
        summary: Get Futures Account Transfer Out Ledger
        description: This endpoint can get futures account transfer out ledger
        documentation: https://www.kucoin.com/docs-new/api-3470307
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | FUTURES    |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | GENERAL    |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 20         |
        +---------------------+------------+
        """
        pass


class TransferAPIImpl(TransferAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def get_transfer_quotas(self, req: GetTransferQuotasReq,
                            **kwargs: Any) -> GetTransferQuotasResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/accounts/transferable", req,
                                   GetTransferQuotasResp(), False, **kwargs)

    def flex_transfer(self, req: FlexTransferReq,
                      **kwargs: Any) -> FlexTransferResp:
        return self.transport.call("spot", False, "POST",
                                   "/api/v3/accounts/universal-transfer", req,
                                   FlexTransferResp(), False, **kwargs)

    def sub_account_transfer(self, req: SubAccountTransferReq,
                             **kwargs: Any) -> SubAccountTransferResp:
        return self.transport.call("spot", False, "POST",
                                   "/api/v2/accounts/sub-transfer", req,
                                   SubAccountTransferResp(), False, **kwargs)

    def inner_transfer(self, req: InnerTransferReq,
                       **kwargs: Any) -> InnerTransferResp:
        return self.transport.call("spot", False, "POST",
                                   "/api/v2/accounts/inner-transfer", req,
                                   InnerTransferResp(), False, **kwargs)

    def futures_account_transfer_out(
            self, req: FuturesAccountTransferOutReq,
            **kwargs: Any) -> FuturesAccountTransferOutResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v3/transfer-out", req,
                                   FuturesAccountTransferOutResp(), False,
                                   **kwargs)

    def futures_account_transfer_in(
            self, req: FuturesAccountTransferInReq,
            **kwargs: Any) -> FuturesAccountTransferInResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v1/transfer-in", req,
                                   FuturesAccountTransferInResp(), False,
                                   **kwargs)

    def get_futures_account_transfer_out_ledger(
            self, req: GetFuturesAccountTransferOutLedgerReq,
            **kwargs: Any) -> GetFuturesAccountTransferOutLedgerResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/transfer-list", req,
                                   GetFuturesAccountTransferOutLedgerResp(),
                                   False, **kwargs)
