# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class FuturesAccountTransferOutResp(BaseModel, Response):
    """
    FuturesAccountTransferOutResp

    Attributes:
        apply_id (str): Transfer order ID
        biz_no (str): Business number
        pay_account_type (str): Pay account type
        pay_tag (str): Pay account sub type
        remark (str): User remark
        rec_account_type (str): Receive account type
        rec_tag (str): Receive account sub type
        rec_remark (str): Receive account tx remark
        rec_system (str): Receive system
        status (str): Status:APPLY, PROCESSING, PENDING_APPROVAL, APPROVED, REJECTED, PENDING_CANCEL, CANCEL, SUCCESS
        currency (str): Currency
        amount (str): Transfer amout
        fee (str): Transfer fee
        sn (int): Serial number
        reason (str): Fail Reason
        created_at (int): Create time
        updated_at (int): Update time
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    apply_id: Optional[str] = Field(default=None,
                                    description="Transfer order ID",
                                    alias="applyId")
    biz_no: Optional[str] = Field(default=None,
                                  description="Business number",
                                  alias="bizNo")
    pay_account_type: Optional[str] = Field(default=None,
                                            description="Pay account type",
                                            alias="payAccountType")
    pay_tag: Optional[str] = Field(default=None,
                                   description="Pay account sub type",
                                   alias="payTag")
    remark: Optional[str] = Field(default=None, description="User remark")
    rec_account_type: Optional[str] = Field(default=None,
                                            description="Receive account type",
                                            alias="recAccountType")
    rec_tag: Optional[str] = Field(default=None,
                                   description="Receive account sub type",
                                   alias="recTag")
    rec_remark: Optional[str] = Field(default=None,
                                      description="Receive account tx remark",
                                      alias="recRemark")
    rec_system: Optional[str] = Field(default=None,
                                      description="Receive system",
                                      alias="recSystem")
    status: Optional[str] = Field(
        default=None,
        description=
        "Status:APPLY, PROCESSING, PENDING_APPROVAL, APPROVED, REJECTED, PENDING_CANCEL, CANCEL, SUCCESS"
    )
    currency: Optional[str] = Field(default=None, description="Currency")
    amount: Optional[str] = Field(default=None, description="Transfer amout")
    fee: Optional[str] = Field(default=None, description="Transfer fee")
    sn: Optional[int] = Field(default=None, description="Serial number")
    reason: Optional[str] = Field(default=None, description="Fail Reason")
    created_at: Optional[int] = Field(default=None,
                                      description="Create time",
                                      alias="createdAt")
    updated_at: Optional[int] = Field(default=None,
                                      description="Update time",
                                      alias="updatedAt")

    __properties: ClassVar[List[str]] = [
        "applyId", "bizNo", "payAccountType", "payTag", "remark",
        "recAccountType", "recTag", "recRemark", "recSystem", "status",
        "currency", "amount", "fee", "sn", "reason", "createdAt", "updatedAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[FuturesAccountTransferOutResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[FuturesAccountTransferOutResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applyId": obj.get("applyId"),
            "bizNo": obj.get("bizNo"),
            "payAccountType": obj.get("payAccountType"),
            "payTag": obj.get("payTag"),
            "remark": obj.get("remark"),
            "recAccountType": obj.get("recAccountType"),
            "recTag": obj.get("recTag"),
            "recRemark": obj.get("recRemark"),
            "recSystem": obj.get("recSystem"),
            "status": obj.get("status"),
            "currency": obj.get("currency"),
            "amount": obj.get("amount"),
            "fee": obj.get("fee"),
            "sn": obj.get("sn"),
            "reason": obj.get("reason"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
