# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetFuturesAccountTransferOutLedgerItems(BaseModel):
    """
    GetFuturesAccountTransferOutLedgerItems

    Attributes:
        apply_id (str): Transfer order ID
        currency (str): Currency
        rec_remark (str): Receive account tx remark
        rec_system (str): Receive system
        status (StatusEnum): Status PROCESSING, SUCCESS, FAILURE
        amount (str): Transaction amount
        reason (str): Reason caused the failure
        offset (int): Offset
        created_at (int): Request application time
        remark (str): User remark
    """

    class StatusEnum(Enum):
        """
        Attributes:
            PROCESSING: 
            SUCCESS: 
            FAILURE: 
        """
        PROCESSING = 'PROCESSING'
        SUCCESS = 'SUCCESS'
        FAILURE = 'FAILURE'

    apply_id: Optional[str] = Field(default=None,
                                    description="Transfer order ID",
                                    alias="applyId")
    currency: Optional[str] = Field(default=None, description="Currency")
    rec_remark: Optional[str] = Field(default=None,
                                      description="Receive account tx remark",
                                      alias="recRemark")
    rec_system: Optional[str] = Field(default=None,
                                      description="Receive system",
                                      alias="recSystem")
    status: Optional[StatusEnum] = Field(
        default=None, description="Status PROCESSING, SUCCESS, FAILURE")
    amount: Optional[str] = Field(default=None,
                                  description="Transaction amount")
    reason: Optional[str] = Field(default=None,
                                  description="Reason caused the failure")
    offset: Optional[int] = Field(default=None, description="Offset")
    created_at: Optional[int] = Field(default=None,
                                      description="Request application time",
                                      alias="createdAt")
    remark: Optional[str] = Field(default=None, description="User remark")

    __properties: ClassVar[List[str]] = [
        "applyId", "currency", "recRemark", "recSystem", "status", "amount",
        "reason", "offset", "createdAt", "remark"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(
            cls, json_str: str
    ) -> Optional[GetFuturesAccountTransferOutLedgerItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls, obj: Optional[Dict[str, Any]]
    ) -> Optional[GetFuturesAccountTransferOutLedgerItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applyId": obj.get("applyId"),
            "currency": obj.get("currency"),
            "recRemark": obj.get("recRemark"),
            "recSystem": obj.get("recSystem"),
            "status": obj.get("status"),
            "amount": obj.get("amount"),
            "reason": obj.get("reason"),
            "offset": obj.get("offset"),
            "createdAt": obj.get("createdAt"),
            "remark": obj.get("remark")
        })
        return _obj
