# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class SubAccountTransferReq(BaseModel):
    """
    SubAccountTransferReq

    Attributes:
        client_oid (str): Unique order id created by users to identify their orders, e.g. UUID, with a maximum length of 128 bits
        currency (str): currency
        amount (str): Transfer amount, the amount is a positive integer multiple of the currency precision.
        direction (DirectionEnum): OUT — the master user to sub user IN — the sub user to the master user.
        account_type (AccountTypeEnum): Account type：MAIN、TRADE、CONTRACT、MARGIN
        sub_account_type (SubAccountTypeEnum): Sub Account type：MAIN、TRADE、CONTRACT、MARGIN
        sub_user_id (str): the user ID of a sub-account.
    """

    class DirectionEnum(Enum):
        """
        Attributes:
            IN_: 
            OUT: 
        """
        IN_ = 'IN'
        OUT = 'OUT'

    class AccountTypeEnum(Enum):
        """
        Attributes:
            MAIN: Funding account
            TRADE: Spot account
            MARGIN: Margin account
            CONTRACT: Futures account
            OPTION: Option account
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'
        MARGIN = 'MARGIN'
        CONTRACT = 'CONTRACT'
        OPTION = 'OPTION'

    class SubAccountTypeEnum(Enum):
        """
        Attributes:
            MAIN: 
            TRADE: 
            MARGIN: 
            CONTRACT: 
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'
        MARGIN = 'MARGIN'
        CONTRACT = 'CONTRACT'

    client_oid: Optional[str] = Field(
        default=None,
        description=
        "Unique order id created by users to identify their orders, e.g. UUID, with a maximum length of 128 bits",
        alias="clientOid")
    currency: Optional[str] = Field(default=None, description="currency")
    amount: Optional[str] = Field(
        default=None,
        description=
        "Transfer amount, the amount is a positive integer multiple of the currency precision."
    )
    direction: Optional[DirectionEnum] = Field(
        default=None,
        description=
        "OUT — the master user to sub user IN — the sub user to the master user."
    )
    account_type: Optional[AccountTypeEnum] = Field(
        default=AccountTypeEnum.MAIN,
        description="Account type：MAIN、TRADE、CONTRACT、MARGIN",
        alias="accountType")
    sub_account_type: Optional[SubAccountTypeEnum] = Field(
        default=SubAccountTypeEnum.MAIN,
        description="Sub Account type：MAIN、TRADE、CONTRACT、MARGIN",
        alias="subAccountType")
    sub_user_id: Optional[str] = Field(
        default=None,
        description="the user ID of a sub-account.",
        alias="subUserId")

    __properties: ClassVar[List[str]] = [
        "clientOid", "currency", "amount", "direction", "accountType",
        "subAccountType", "subUserId"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[SubAccountTransferReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[SubAccountTransferReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clientOid":
            obj.get("clientOid"),
            "currency":
            obj.get("currency"),
            "amount":
            obj.get("amount"),
            "direction":
            obj.get("direction"),
            "accountType":
            obj.get("accountType") if obj.get("accountType") is not None else
            SubAccountTransferReq.AccountTypeEnum.MAIN,
            "subAccountType":
            obj.get("subAccountType") if obj.get("subAccountType") is not None
            else SubAccountTransferReq.SubAccountTypeEnum.MAIN,
            "subUserId":
            obj.get("subUserId")
        })
        return _obj


class SubAccountTransferReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_client_oid(self, value: str) -> SubAccountTransferReqBuilder:
        """
        Unique order id created by users to identify their orders, e.g. UUID, with a maximum length of 128 bits
        """
        self.obj['clientOid'] = value
        return self

    def set_currency(self, value: str) -> SubAccountTransferReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_amount(self, value: str) -> SubAccountTransferReqBuilder:
        """
        Transfer amount, the amount is a positive integer multiple of the currency precision.
        """
        self.obj['amount'] = value
        return self

    def set_direction(
        self, value: SubAccountTransferReq.DirectionEnum
    ) -> SubAccountTransferReqBuilder:
        """
        OUT — the master user to sub user IN — the sub user to the master user.
        """
        self.obj['direction'] = value
        return self

    def set_account_type(
        self, value: SubAccountTransferReq.AccountTypeEnum
    ) -> SubAccountTransferReqBuilder:
        """
        Account type：MAIN、TRADE、CONTRACT、MARGIN
        """
        self.obj['accountType'] = value
        return self

    def set_sub_account_type(
        self, value: SubAccountTransferReq.SubAccountTypeEnum
    ) -> SubAccountTransferReqBuilder:
        """
        Sub Account type：MAIN、TRADE、CONTRACT、MARGIN
        """
        self.obj['subAccountType'] = value
        return self

    def set_sub_user_id(self, value: str) -> SubAccountTransferReqBuilder:
        """
        the user ID of a sub-account.
        """
        self.obj['subUserId'] = value
        return self

    def build(self) -> SubAccountTransferReq:
        return SubAccountTransferReq(**self.obj)
