# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_cancel_withdrawal_req import CancelWithdrawalReq
from .model_cancel_withdrawal_resp import CancelWithdrawalResp
from .model_get_withdrawal_history_old_req import GetWithdrawalHistoryOldReq
from .model_get_withdrawal_history_old_resp import GetWithdrawalHistoryOldResp
from .model_get_withdrawal_history_req import GetWithdrawalHistoryReq
from .model_get_withdrawal_history_resp import GetWithdrawalHistoryResp
from .model_get_withdrawal_quotas_req import GetWithdrawalQuotasReq
from .model_get_withdrawal_quotas_resp import GetWithdrawalQuotasResp
from .model_withdrawal_v1_req import WithdrawalV1Req
from .model_withdrawal_v1_resp import WithdrawalV1Resp
from .model_withdrawal_v3_req import WithdrawalV3Req
from .model_withdrawal_v3_resp import WithdrawalV3Resp
from typing_extensions import deprecated


class WithdrawalAPI(ABC):

    @abstractmethod
    def get_withdrawal_quotas(self, req: GetWithdrawalQuotasReq,
                              **kwargs: Any) -> GetWithdrawalQuotasResp:
        """
        summary: Get Withdrawal Quotas
        description: This interface can obtain the withdrawal quotas information of this currency.
        documentation: https://www.kucoin.com/docs-new/api-3470143
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | SPOT       |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | GENERAL    |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 20         |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    def withdrawal_v3(self, req: WithdrawalV3Req,
                      **kwargs: Any) -> WithdrawalV3Resp:
        """
        summary: Withdraw(V3)
        description: Use this interface to withdraw the specified currency
        documentation: https://www.kucoin.com/docs-new/api-3470146
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | SPOT       |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | WITHDRAWAL |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 5          |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    def cancel_withdrawal(self, req: CancelWithdrawalReq,
                          **kwargs: Any) -> CancelWithdrawalResp:
        """
        summary: Cancel Withdrawal
        description: This interface can cancel the withdrawal, Only withdrawals requests of PROCESSING status could be canceled.
        documentation: https://www.kucoin.com/docs-new/api-3470144
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | SPOT       |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | WITHDRAWAL |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 20         |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    def get_withdrawal_history(self, req: GetWithdrawalHistoryReq,
                               **kwargs: Any) -> GetWithdrawalHistoryResp:
        """
        summary: Get Withdrawal History
        description: Request via this endpoint to get deposit list Items are paginated and sorted to show the latest first. See the Pagination section for retrieving additional entries after the first page.
        documentation: https://www.kucoin.com/docs-new/api-3470145
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | SPOT       |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | GENERAL    |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 20         |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def get_withdrawal_history_old(
            self, req: GetWithdrawalHistoryOldReq,
            **kwargs: Any) -> GetWithdrawalHistoryOldResp:
        """
        summary: Get Withdrawal History - Old
        description: Request via this endpoint to get deposit list Items are paginated and sorted to show the latest first. See the Pagination section for retrieving additional entries after the first page.
        documentation: https://www.kucoin.com/docs-new/api-3470308
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | SPOT       |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | GENERAL    |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 20         |
        +---------------------+------------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def withdrawal_v1(self, req: WithdrawalV1Req,
                      **kwargs: Any) -> WithdrawalV1Resp:
        """
        summary: Withdraw - V1
        description: Use this interface to withdraw the specified currency
        documentation: https://www.kucoin.com/docs-new/api-3470310
        +---------------------+------------+
        | Extra API Info      | Value      |
        +---------------------+------------+
        | API-DOMAIN          | SPOT       |
        | API-CHANNEL         | PRIVATE    |
        | API-PERMISSION      | WITHDRAWAL |
        | API-RATE-LIMIT-POOL | MANAGEMENT |
        | API-RATE-LIMIT      | 5          |
        +---------------------+------------+
        """
        pass


class WithdrawalAPIImpl(WithdrawalAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def get_withdrawal_quotas(self, req: GetWithdrawalQuotasReq,
                              **kwargs: Any) -> GetWithdrawalQuotasResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/withdrawals/quotas", req,
                                   GetWithdrawalQuotasResp(), False, **kwargs)

    def withdrawal_v3(self, req: WithdrawalV3Req,
                      **kwargs: Any) -> WithdrawalV3Resp:
        return self.transport.call("spot", False, "POST",
                                   "/api/v3/withdrawals", req,
                                   WithdrawalV3Resp(), False, **kwargs)

    def cancel_withdrawal(self, req: CancelWithdrawalReq,
                          **kwargs: Any) -> CancelWithdrawalResp:
        return self.transport.call("spot", False, "DELETE",
                                   "/api/v1/withdrawals/{withdrawalId}", req,
                                   CancelWithdrawalResp(), False, **kwargs)

    def get_withdrawal_history(self, req: GetWithdrawalHistoryReq,
                               **kwargs: Any) -> GetWithdrawalHistoryResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/withdrawals", req,
                                   GetWithdrawalHistoryResp(), False, **kwargs)

    def get_withdrawal_history_old(
            self, req: GetWithdrawalHistoryOldReq,
            **kwargs: Any) -> GetWithdrawalHistoryOldResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/hist-withdrawals", req,
                                   GetWithdrawalHistoryOldResp(), False,
                                   **kwargs)

    def withdrawal_v1(self, req: WithdrawalV1Req,
                      **kwargs: Any) -> WithdrawalV1Resp:
        return self.transport.call("spot", False, "POST",
                                   "/api/v1/withdrawals", req,
                                   WithdrawalV1Resp(), False, **kwargs)
