# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetWithdrawalHistoryItems(BaseModel):
    """
    GetWithdrawalHistoryItems

    Attributes:
        id (str): Unique id
        currency (str): Currency
        chain (str): The id of currency
        status (StatusEnum): Status
        address (str): Deposit address
        memo (str): Address remark. If there’s no remark, it is empty. 
        is_inner (bool): Internal deposit or not
        amount (str): Deposit amount
        fee (str): Fees charged for deposit
        wallet_tx_id (str): Wallet Txid
        created_at (int): Creation time of the database record
        updated_at (int): Update time of the database record
        remark (str): remark
    """

    class StatusEnum(Enum):
        """
        Attributes:
            PROCESSING: 
            WALLET_PROCESSING: 
            SUCCESS: 
            FAILURE: 
        """
        PROCESSING = 'PROCESSING'
        WALLET_PROCESSING = 'WALLET_PROCESSING'
        SUCCESS = 'SUCCESS'
        FAILURE = 'FAILURE'

    id: Optional[str] = Field(default=None, description="Unique id")
    currency: Optional[str] = Field(default=None, description="Currency")
    chain: Optional[str] = Field(default=None,
                                 description="The id of currency")
    status: Optional[StatusEnum] = Field(default=None, description="Status")
    address: Optional[str] = Field(default=None, description="Deposit address")
    memo: Optional[str] = Field(
        default=None,
        description="Address remark. If there’s no remark, it is empty. ")
    is_inner: Optional[bool] = Field(default=None,
                                     description="Internal deposit or not",
                                     alias="isInner")
    amount: Optional[str] = Field(default=None, description="Deposit amount")
    fee: Optional[str] = Field(default=None,
                               description="Fees charged for deposit")
    wallet_tx_id: Optional[str] = Field(default=None,
                                        description="Wallet Txid",
                                        alias="walletTxId")
    created_at: Optional[int] = Field(
        default=None,
        description="Creation time of the database record",
        alias="createdAt")
    updated_at: Optional[int] = Field(
        default=None,
        description="Update time of the database record",
        alias="updatedAt")
    remark: Optional[str] = Field(default=None, description="remark")

    __properties: ClassVar[List[str]] = [
        "id", "currency", "chain", "status", "address", "memo", "isInner",
        "amount", "fee", "walletTxId", "createdAt", "updatedAt", "remark"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetWithdrawalHistoryItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetWithdrawalHistoryItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "currency": obj.get("currency"),
            "chain": obj.get("chain"),
            "status": obj.get("status"),
            "address": obj.get("address"),
            "memo": obj.get("memo"),
            "isInner": obj.get("isInner"),
            "amount": obj.get("amount"),
            "fee": obj.get("fee"),
            "walletTxId": obj.get("walletTxId"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "remark": obj.get("remark")
        })
        return _obj
