# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetWithdrawalQuotasResp(BaseModel, Response):
    """
    GetWithdrawalQuotasResp

    Attributes:
        currency (str): 
        limit_btc_amount (str): 
        used_btc_amount (str): 
        quota_currency (str): withdrawal limit currency
        limit_quota_currency_amount (str): The intraday available withdrawal amount(withdrawal limit currency)
        used_quota_currency_amount (str): The intraday cumulative withdrawal amount(withdrawal limit currency)
        remain_amount (str): Remaining amount available to withdraw the current day 
        available_amount (str): Current available withdrawal amount
        withdraw_min_fee (str): Minimum withdrawal fee
        inner_withdraw_min_fee (str): Fees for internal withdrawal
        withdraw_min_size (str): Minimum withdrawal amount
        is_withdraw_enabled (bool): Is the withdraw function enabled or not
        precision (int): Floating point precision.
        chain (str): The chainName of currency
        reason (str): Reasons for restriction, Usually empty
        locked_amount (str): Total locked amount (including the amount locked into USDT for each currency)
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    currency: Optional[str] = None
    limit_btc_amount: Optional[str] = Field(default=None,
                                            alias="limitBTCAmount")
    used_btc_amount: Optional[str] = Field(default=None, alias="usedBTCAmount")
    quota_currency: Optional[str] = Field(
        default=None,
        description="withdrawal limit currency",
        alias="quotaCurrency")
    limit_quota_currency_amount: Optional[str] = Field(
        default=None,
        description=
        "The intraday available withdrawal amount(withdrawal limit currency)",
        alias="limitQuotaCurrencyAmount")
    used_quota_currency_amount: Optional[str] = Field(
        default=None,
        description=
        "The intraday cumulative withdrawal amount(withdrawal limit currency)",
        alias="usedQuotaCurrencyAmount")
    remain_amount: Optional[str] = Field(
        default=None,
        description="Remaining amount available to withdraw the current day ",
        alias="remainAmount")
    available_amount: Optional[str] = Field(
        default=None,
        description="Current available withdrawal amount",
        alias="availableAmount")
    withdraw_min_fee: Optional[str] = Field(
        default=None,
        description="Minimum withdrawal fee",
        alias="withdrawMinFee")
    inner_withdraw_min_fee: Optional[str] = Field(
        default=None,
        description="Fees for internal withdrawal",
        alias="innerWithdrawMinFee")
    withdraw_min_size: Optional[str] = Field(
        default=None,
        description="Minimum withdrawal amount",
        alias="withdrawMinSize")
    is_withdraw_enabled: Optional[bool] = Field(
        default=None,
        description="Is the withdraw function enabled or not",
        alias="isWithdrawEnabled")
    precision: Optional[int] = Field(default=None,
                                     description="Floating point precision.")
    chain: Optional[str] = Field(default=None,
                                 description="The chainName of currency")
    reason: Optional[str] = Field(
        default=None, description="Reasons for restriction, Usually empty")
    locked_amount: Optional[str] = Field(
        default=None,
        description=
        "Total locked amount (including the amount locked into USDT for each currency)",
        alias="lockedAmount")

    __properties: ClassVar[List[str]] = [
        "currency", "limitBTCAmount", "usedBTCAmount", "quotaCurrency",
        "limitQuotaCurrencyAmount", "usedQuotaCurrencyAmount", "remainAmount",
        "availableAmount", "withdrawMinFee", "innerWithdrawMinFee",
        "withdrawMinSize", "isWithdrawEnabled", "precision", "chain", "reason",
        "lockedAmount"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetWithdrawalQuotasResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetWithdrawalQuotasResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "limitBTCAmount":
            obj.get("limitBTCAmount"),
            "usedBTCAmount":
            obj.get("usedBTCAmount"),
            "quotaCurrency":
            obj.get("quotaCurrency"),
            "limitQuotaCurrencyAmount":
            obj.get("limitQuotaCurrencyAmount"),
            "usedQuotaCurrencyAmount":
            obj.get("usedQuotaCurrencyAmount"),
            "remainAmount":
            obj.get("remainAmount"),
            "availableAmount":
            obj.get("availableAmount"),
            "withdrawMinFee":
            obj.get("withdrawMinFee"),
            "innerWithdrawMinFee":
            obj.get("innerWithdrawMinFee"),
            "withdrawMinSize":
            obj.get("withdrawMinSize"),
            "isWithdrawEnabled":
            obj.get("isWithdrawEnabled"),
            "precision":
            obj.get("precision"),
            "chain":
            obj.get("chain"),
            "reason":
            obj.get("reason"),
            "lockedAmount":
            obj.get("lockedAmount")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
