# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class WithdrawalV1Req(BaseModel):
    """
    WithdrawalV1Req

    Attributes:
        currency (str): currency
        chain (str): The chainId of currency, For a currency with multiple chains, it is recommended to specify chain parameter instead of using the default chain; you can query the chainId through the response of the GET /api/v3/currencies/{currency} interface.
        address (str): Withdrawal address
        amount (int): Withdrawal amount, a positive number which is a multiple of the amount precision
        memo (str): Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to the KuCoin, you need to fill in memo(tag). If you do not fill memo (tag), your deposit may not be available, please be cautious.
        is_inner (bool): Internal withdrawal or not. Default : false
        remark (str): remark
        fee_deduct_type (str): Withdrawal fee deduction type: INTERNAL or EXTERNAL or not specified  1. INTERNAL- deduct the transaction fees from your withdrawal amount 2. EXTERNAL- deduct the transaction fees from your main account 3. If you don't specify the feeDeductType parameter, when the balance in your main account is sufficient to support the withdrawal, the system will initially deduct the transaction fees from your main account. But if the balance in your main account is not sufficient to support the withdrawal, the system will deduct the fees from your withdrawal amount. For example: Suppose you are going to withdraw 1 BTC from the KuCoin platform (transaction fee: 0.0001BTC), if the balance in your main account is insufficient, the system will deduct the transaction fees from your withdrawal amount. In this case, you will be receiving 0.9999BTC.
    """

    currency: Optional[str] = Field(default=None, description="currency")
    chain: Optional[str] = Field(
        default='eth',
        description=
        "The chainId of currency, For a currency with multiple chains, it is recommended to specify chain parameter instead of using the default chain; you can query the chainId through the response of the GET /api/v3/currencies/{currency} interface."
    )
    address: Optional[str] = Field(default=None,
                                   description="Withdrawal address")
    amount: Optional[int] = Field(
        default=None,
        description=
        "Withdrawal amount, a positive number which is a multiple of the amount precision"
    )
    memo: Optional[str] = Field(
        default=None,
        description=
        "Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to the KuCoin, you need to fill in memo(tag). If you do not fill memo (tag), your deposit may not be available, please be cautious."
    )
    is_inner: Optional[bool] = Field(
        default=False,
        description="Internal withdrawal or not. Default : false",
        alias="isInner")
    remark: Optional[str] = Field(default=None, description="remark")
    fee_deduct_type: Optional[str] = Field(
        default=None,
        description=
        "Withdrawal fee deduction type: INTERNAL or EXTERNAL or not specified  1. INTERNAL- deduct the transaction fees from your withdrawal amount 2. EXTERNAL- deduct the transaction fees from your main account 3. If you don't specify the feeDeductType parameter, when the balance in your main account is sufficient to support the withdrawal, the system will initially deduct the transaction fees from your main account. But if the balance in your main account is not sufficient to support the withdrawal, the system will deduct the fees from your withdrawal amount. For example: Suppose you are going to withdraw 1 BTC from the KuCoin platform (transaction fee: 0.0001BTC), if the balance in your main account is insufficient, the system will deduct the transaction fees from your withdrawal amount. In this case, you will be receiving 0.9999BTC.",
        alias="feeDeductType")

    __properties: ClassVar[List[str]] = [
        "currency", "chain", "address", "amount", "memo", "isInner", "remark",
        "feeDeductType"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[WithdrawalV1Req]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[WithdrawalV1Req]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "chain":
            obj.get("chain") if obj.get("chain") is not None else 'eth',
            "address":
            obj.get("address"),
            "amount":
            obj.get("amount"),
            "memo":
            obj.get("memo"),
            "isInner":
            obj.get("isInner") if obj.get("isInner") is not None else False,
            "remark":
            obj.get("remark"),
            "feeDeductType":
            obj.get("feeDeductType")
        })
        return _obj


class WithdrawalV1ReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> WithdrawalV1ReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_chain(self, value: str) -> WithdrawalV1ReqBuilder:
        """
        The chainId of currency, For a currency with multiple chains, it is recommended to specify chain parameter instead of using the default chain; you can query the chainId through the response of the GET /api/v3/currencies/{currency} interface.
        """
        self.obj['chain'] = value
        return self

    def set_address(self, value: str) -> WithdrawalV1ReqBuilder:
        """
        Withdrawal address
        """
        self.obj['address'] = value
        return self

    def set_amount(self, value: int) -> WithdrawalV1ReqBuilder:
        """
        Withdrawal amount, a positive number which is a multiple of the amount precision
        """
        self.obj['amount'] = value
        return self

    def set_memo(self, value: str) -> WithdrawalV1ReqBuilder:
        """
        Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to the KuCoin, you need to fill in memo(tag). If you do not fill memo (tag), your deposit may not be available, please be cautious.
        """
        self.obj['memo'] = value
        return self

    def set_is_inner(self, value: bool) -> WithdrawalV1ReqBuilder:
        """
        Internal withdrawal or not. Default : false
        """
        self.obj['isInner'] = value
        return self

    def set_remark(self, value: str) -> WithdrawalV1ReqBuilder:
        """
        remark
        """
        self.obj['remark'] = value
        return self

    def set_fee_deduct_type(self, value: str) -> WithdrawalV1ReqBuilder:
        """
        Withdrawal fee deduction type: INTERNAL or EXTERNAL or not specified  1. INTERNAL- deduct the transaction fees from your withdrawal amount 2. EXTERNAL- deduct the transaction fees from your main account 3. If you don't specify the feeDeductType parameter, when the balance in your main account is sufficient to support the withdrawal, the system will initially deduct the transaction fees from your main account. But if the balance in your main account is not sufficient to support the withdrawal, the system will deduct the fees from your withdrawal amount. For example: Suppose you are going to withdraw 1 BTC from the KuCoin platform (transaction fee: 0.0001BTC), if the balance in your main account is insufficient, the system will deduct the transaction fees from your withdrawal amount. In this case, you will be receiving 0.9999BTC.
        """
        self.obj['feeDeductType'] = value
        return self

    def build(self) -> WithdrawalV1Req:
        return WithdrawalV1Req(**self.obj)
