# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetDepositListData(BaseModel):
    """
    GetDepositListData

    Attributes:
        uid (float): deposit uid
        hash (str): hash
        address (str): Deposit address
        memo (str): Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to the KuCoin, you need to fill in memo(tag). If you do not fill memo (tag), your deposit may not be available, please be cautious.
        amount (str): Deposit amount
        fee (str): Fees charged for deposit
        currency (str): currency
        is_inner (bool): Internal deposit or not
        wallet_tx_id (str): Wallet Txid
        status (StatusEnum): Status. Available value: PROCESSING, SUCCESS, FAILURE
        remark (str): remark
        chain (str): chain name of currency
        created_at (int): Creation time of the database record
        updated_at (int): Update time of the database record
    """

    class StatusEnum(Enum):
        """
        Attributes:
            PROCESSING: 
            SUCCESS: 
            FAILURE: 
        """
        PROCESSING = 'PROCESSING'
        SUCCESS = 'SUCCESS'
        FAILURE = 'FAILURE'

    uid: Optional[float] = Field(default=None, description="deposit uid")
    hash: Optional[str] = Field(default=None, description="hash")
    address: Optional[str] = Field(default=None, description="Deposit address")
    memo: Optional[str] = Field(
        default=None,
        description=
        "Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to the KuCoin, you need to fill in memo(tag). If you do not fill memo (tag), your deposit may not be available, please be cautious."
    )
    amount: Optional[str] = Field(default=None, description="Deposit amount")
    fee: Optional[str] = Field(default=None,
                               description="Fees charged for deposit")
    currency: Optional[str] = Field(default=None, description="currency")
    is_inner: Optional[bool] = Field(default=None,
                                     description="Internal deposit or not",
                                     alias="isInner")
    wallet_tx_id: Optional[str] = Field(default=None,
                                        description="Wallet Txid",
                                        alias="walletTxId")
    status: Optional[StatusEnum] = Field(
        default=None,
        description="Status. Available value: PROCESSING, SUCCESS, FAILURE")
    remark: Optional[str] = Field(default=None, description="remark")
    chain: Optional[str] = Field(default=None,
                                 description="chain name of currency")
    created_at: Optional[int] = Field(
        default=None,
        description="Creation time of the database record",
        alias="createdAt")
    updated_at: Optional[int] = Field(
        default=None,
        description="Update time of the database record",
        alias="updatedAt")

    __properties: ClassVar[List[str]] = [
        "uid", "hash", "address", "memo", "amount", "fee", "currency",
        "isInner", "walletTxId", "status", "remark", "chain", "createdAt",
        "updatedAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetDepositListData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetDepositListData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uid": obj.get("uid"),
            "hash": obj.get("hash"),
            "address": obj.get("address"),
            "memo": obj.get("memo"),
            "amount": obj.get("amount"),
            "fee": obj.get("fee"),
            "currency": obj.get("currency"),
            "isInner": obj.get("isInner"),
            "walletTxId": obj.get("walletTxId"),
            "status": obj.get("status"),
            "remark": obj.get("remark"),
            "chain": obj.get("chain"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj
