# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated


class GetDepositListReq(BaseModel):
    """
    GetDepositListReq

    Attributes:
        currency (str): currency
        status (str): Status. Available value: PROCESSING, SUCCESS, FAILURE
        hash (str): hash
        start_timestamp (int): Start time (milisecond)
        end_timestamp (int): End time (milisecond)，Default sorting in descending order
        limit (int): Maximum number of returned items, maximum 1000, default 1000
    """

    currency: Optional[str] = Field(default=None, description="currency")
    status: Optional[str] = Field(
        default=None,
        description="Status. Available value: PROCESSING, SUCCESS, FAILURE")
    hash: Optional[str] = Field(default=None, description="hash")
    start_timestamp: Optional[int] = Field(
        default=None,
        description="Start time (milisecond)",
        alias="startTimestamp")
    end_timestamp: Optional[int] = Field(
        default=None,
        description="End time (milisecond)，Default sorting in descending order",
        alias="endTimestamp")
    limit: Optional[Annotated[int, Field(le=1000, strict=True)]] = Field(
        default=1000,
        description=
        "Maximum number of returned items, maximum 1000, default 1000")

    __properties: ClassVar[List[str]] = [
        "currency", "status", "hash", "startTimestamp", "endTimestamp", "limit"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetDepositListReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str, Any]]) -> Optional[GetDepositListReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "status":
            obj.get("status"),
            "hash":
            obj.get("hash"),
            "startTimestamp":
            obj.get("startTimestamp"),
            "endTimestamp":
            obj.get("endTimestamp"),
            "limit":
            obj.get("limit") if obj.get("limit") is not None else 1000
        })
        return _obj


class GetDepositListReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetDepositListReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_status(self, value: str) -> GetDepositListReqBuilder:
        """
        Status. Available value: PROCESSING, SUCCESS, FAILURE
        """
        self.obj['status'] = value
        return self

    def set_hash(self, value: str) -> GetDepositListReqBuilder:
        """
        hash
        """
        self.obj['hash'] = value
        return self

    def set_start_timestamp(self, value: int) -> GetDepositListReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startTimestamp'] = value
        return self

    def set_end_timestamp(self, value: int) -> GetDepositListReqBuilder:
        """
        End time (milisecond)，Default sorting in descending order
        """
        self.obj['endTimestamp'] = value
        return self

    def set_limit(self, value: int) -> GetDepositListReqBuilder:
        """
        Maximum number of returned items, maximum 1000, default 1000
        """
        self.obj['limit'] = value
        return self

    def build(self) -> GetDepositListReq:
        return GetDepositListReq(**self.obj)
