# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class AddIsolatedMarginReq(BaseModel):
    """
    AddIsolatedMarginReq

    Attributes:
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        margin (float): Margin amount (min. margin amount≥0.00001667XBT）
        biz_no (str): A unique ID generated by the user, to ensure the operation is processed by the system only once, The maximum length cannot exceed 36
    """

    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    margin: Optional[float] = Field(
        default=None,
        description="Margin amount (min. margin amount≥0.00001667XBT）")
    biz_no: Optional[str] = Field(
        default=None,
        description=
        "A unique ID generated by the user, to ensure the operation is processed by the system only once, The maximum length cannot exceed 36",
        alias="bizNo")

    __properties: ClassVar[List[str]] = ["symbol", "margin", "bizNo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AddIsolatedMarginReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[AddIsolatedMarginReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "margin": obj.get("margin"),
            "bizNo": obj.get("bizNo")
        })
        return _obj


class AddIsolatedMarginReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> AddIsolatedMarginReqBuilder:
        """
        Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        """
        self.obj['symbol'] = value
        return self

    def set_margin(self, value: float) -> AddIsolatedMarginReqBuilder:
        """
        Margin amount (min. margin amount≥0.00001667XBT）
        """
        self.obj['margin'] = value
        return self

    def set_biz_no(self, value: str) -> AddIsolatedMarginReqBuilder:
        """
        A unique ID generated by the user, to ensure the operation is processed by the system only once, The maximum length cannot exceed 36
        """
        self.obj['bizNo'] = value
        return self

    def build(self) -> AddIsolatedMarginReq:
        return AddIsolatedMarginReq(**self.obj)
