# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class AddIsolatedMarginResp(BaseModel, Response):
    """
    AddIsolatedMarginResp

    Attributes:
        id (str): Position ID
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        auto_deposit (bool): Auto deposit margin or not
        maint_margin_req (str): Maintenance margin requirement  
        risk_limit (int): Risk limit 
        real_leverage (str): Leverage o the order
        cross_mode (bool): Cross mode or not
        delev_percentage (float): ADL ranking percentile
        opening_timestamp (int): Open time
        current_timestamp (int): Current timestamp 
        current_qty (int): Current postion quantity
        current_cost (str): Current postion value
        current_comm (str): Current commission
        unrealised_cost (str): Unrealised value
        realised_gross_cost (str): Accumulated realised gross profit value
        realised_cost (str): Current realised position value
        is_open (bool): Opened position or not
        mark_price (str): Mark price
        mark_value (str): Mark value 
        pos_cost (str): Position value
        pos_cross (str): added margin
        pos_init (str): Leverage margin
        pos_comm (str): Bankruptcy cost
        pos_loss (str): Funding fees paid out
        pos_margin (str): Position margin
        pos_maint (str): Maintenance margin
        maint_margin (str): Position margin
        realised_gross_pnl (str): Accumulated realised gross profit value
        realised_pnl (str): Realised profit and loss
        unrealised_pnl (str): Unrealised profit and loss
        unrealised_pnl_pcnt (str): Profit-loss ratio of the position
        unrealised_roe_pcnt (str): Rate of return on investment
        avg_entry_price (str): Average entry price
        liquidation_price (str): Liquidation price
        bankrupt_price (str): Bankruptcy price
        settle_currency (str): Currency used to clear and settle the trades
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    id: Optional[str] = Field(default=None, description="Position ID")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    auto_deposit: Optional[bool] = Field(
        default=None,
        description="Auto deposit margin or not",
        alias="autoDeposit")
    maint_margin_req: Optional[str] = Field(
        default=None,
        description="Maintenance margin requirement  ",
        alias="maintMarginReq")
    risk_limit: Optional[int] = Field(default=None,
                                      description="Risk limit ",
                                      alias="riskLimit")
    real_leverage: Optional[str] = Field(default=None,
                                         description="Leverage o the order",
                                         alias="realLeverage")
    cross_mode: Optional[bool] = Field(default=None,
                                       description="Cross mode or not",
                                       alias="crossMode")
    delev_percentage: Optional[float] = Field(
        default=None,
        description="ADL ranking percentile",
        alias="delevPercentage")
    opening_timestamp: Optional[int] = Field(default=None,
                                             description="Open time",
                                             alias="openingTimestamp")
    current_timestamp: Optional[int] = Field(default=None,
                                             description="Current timestamp ",
                                             alias="currentTimestamp")
    current_qty: Optional[int] = Field(default=None,
                                       description="Current postion quantity",
                                       alias="currentQty")
    current_cost: Optional[str] = Field(default=None,
                                        description="Current postion value",
                                        alias="currentCost")
    current_comm: Optional[str] = Field(default=None,
                                        description="Current commission",
                                        alias="currentComm")
    unrealised_cost: Optional[str] = Field(default=None,
                                           description="Unrealised value",
                                           alias="unrealisedCost")
    realised_gross_cost: Optional[str] = Field(
        default=None,
        description="Accumulated realised gross profit value",
        alias="realisedGrossCost")
    realised_cost: Optional[str] = Field(
        default=None,
        description="Current realised position value",
        alias="realisedCost")
    is_open: Optional[bool] = Field(default=None,
                                    description="Opened position or not",
                                    alias="isOpen")
    mark_price: Optional[str] = Field(default=None,
                                      description="Mark price",
                                      alias="markPrice")
    mark_value: Optional[str] = Field(default=None,
                                      description="Mark value ",
                                      alias="markValue")
    pos_cost: Optional[str] = Field(default=None,
                                    description="Position value",
                                    alias="posCost")
    pos_cross: Optional[str] = Field(default=None,
                                     description="added margin",
                                     alias="posCross")
    pos_init: Optional[str] = Field(default=None,
                                    description="Leverage margin",
                                    alias="posInit")
    pos_comm: Optional[str] = Field(default=None,
                                    description="Bankruptcy cost",
                                    alias="posComm")
    pos_loss: Optional[str] = Field(default=None,
                                    description="Funding fees paid out",
                                    alias="posLoss")
    pos_margin: Optional[str] = Field(default=None,
                                      description="Position margin",
                                      alias="posMargin")
    pos_maint: Optional[str] = Field(default=None,
                                     description="Maintenance margin",
                                     alias="posMaint")
    maint_margin: Optional[str] = Field(default=None,
                                        description="Position margin",
                                        alias="maintMargin")
    realised_gross_pnl: Optional[str] = Field(
        default=None,
        description="Accumulated realised gross profit value",
        alias="realisedGrossPnl")
    realised_pnl: Optional[str] = Field(default=None,
                                        description="Realised profit and loss",
                                        alias="realisedPnl")
    unrealised_pnl: Optional[str] = Field(
        default=None,
        description="Unrealised profit and loss",
        alias="unrealisedPnl")
    unrealised_pnl_pcnt: Optional[str] = Field(
        default=None,
        description="Profit-loss ratio of the position",
        alias="unrealisedPnlPcnt")
    unrealised_roe_pcnt: Optional[str] = Field(
        default=None,
        description="Rate of return on investment",
        alias="unrealisedRoePcnt")
    avg_entry_price: Optional[str] = Field(default=None,
                                           description="Average entry price",
                                           alias="avgEntryPrice")
    liquidation_price: Optional[str] = Field(default=None,
                                             description="Liquidation price",
                                             alias="liquidationPrice")
    bankrupt_price: Optional[str] = Field(default=None,
                                          description="Bankruptcy price",
                                          alias="bankruptPrice")
    settle_currency: Optional[str] = Field(
        default=None,
        description="Currency used to clear and settle the trades",
        alias="settleCurrency")

    __properties: ClassVar[List[str]] = [
        "id", "symbol", "autoDeposit", "maintMarginReq", "riskLimit",
        "realLeverage", "crossMode", "delevPercentage", "openingTimestamp",
        "currentTimestamp", "currentQty", "currentCost", "currentComm",
        "unrealisedCost", "realisedGrossCost", "realisedCost", "isOpen",
        "markPrice", "markValue", "posCost", "posCross", "posInit", "posComm",
        "posLoss", "posMargin", "posMaint", "maintMargin", "realisedGrossPnl",
        "realisedPnl", "unrealisedPnl", "unrealisedPnlPcnt",
        "unrealisedRoePcnt", "avgEntryPrice", "liquidationPrice",
        "bankruptPrice", "settleCurrency"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AddIsolatedMarginResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[AddIsolatedMarginResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id":
            obj.get("id"),
            "symbol":
            obj.get("symbol"),
            "autoDeposit":
            obj.get("autoDeposit"),
            "maintMarginReq":
            obj.get("maintMarginReq"),
            "riskLimit":
            obj.get("riskLimit"),
            "realLeverage":
            obj.get("realLeverage"),
            "crossMode":
            obj.get("crossMode"),
            "delevPercentage":
            obj.get("delevPercentage"),
            "openingTimestamp":
            obj.get("openingTimestamp"),
            "currentTimestamp":
            obj.get("currentTimestamp"),
            "currentQty":
            obj.get("currentQty"),
            "currentCost":
            obj.get("currentCost"),
            "currentComm":
            obj.get("currentComm"),
            "unrealisedCost":
            obj.get("unrealisedCost"),
            "realisedGrossCost":
            obj.get("realisedGrossCost"),
            "realisedCost":
            obj.get("realisedCost"),
            "isOpen":
            obj.get("isOpen"),
            "markPrice":
            obj.get("markPrice"),
            "markValue":
            obj.get("markValue"),
            "posCost":
            obj.get("posCost"),
            "posCross":
            obj.get("posCross"),
            "posInit":
            obj.get("posInit"),
            "posComm":
            obj.get("posComm"),
            "posLoss":
            obj.get("posLoss"),
            "posMargin":
            obj.get("posMargin"),
            "posMaint":
            obj.get("posMaint"),
            "maintMargin":
            obj.get("maintMargin"),
            "realisedGrossPnl":
            obj.get("realisedGrossPnl"),
            "realisedPnl":
            obj.get("realisedPnl"),
            "unrealisedPnl":
            obj.get("unrealisedPnl"),
            "unrealisedPnlPcnt":
            obj.get("unrealisedPnlPcnt"),
            "unrealisedRoePcnt":
            obj.get("unrealisedRoePcnt"),
            "avgEntryPrice":
            obj.get("avgEntryPrice"),
            "liquidationPrice":
            obj.get("liquidationPrice"),
            "bankruptPrice":
            obj.get("bankruptPrice"),
            "settleCurrency":
            obj.get("settleCurrency")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
