# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class PurchaseReq(BaseModel):
    """
    PurchaseReq

    Attributes:
        product_id (str): Product Id
        amount (str): Subscription amount
        account_type (AccountTypeEnum): MAIN (funding account), TRADE (spot trading account)
    """

    class AccountTypeEnum(Enum):
        """
        Attributes:
            MAIN: 
            TRADE: 
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'

    product_id: Optional[str] = Field(default=None,
                                      description="Product Id",
                                      alias="productId")
    amount: Optional[str] = Field(default=None,
                                  description="Subscription amount")
    account_type: Optional[AccountTypeEnum] = Field(
        default=None,
        description="MAIN (funding account), TRADE (spot trading account)",
        alias="accountType")

    __properties: ClassVar[List[str]] = ["productId", "amount", "accountType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[PurchaseReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[PurchaseReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "productId": obj.get("productId"),
            "amount": obj.get("amount"),
            "accountType": obj.get("accountType")
        })
        return _obj


class PurchaseReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_product_id(self, value: str) -> PurchaseReqBuilder:
        """
        Product Id
        """
        self.obj['productId'] = value
        return self

    def set_amount(self, value: str) -> PurchaseReqBuilder:
        """
        Subscription amount
        """
        self.obj['amount'] = value
        return self

    def set_account_type(
            self, value: PurchaseReq.AccountTypeEnum) -> PurchaseReqBuilder:
        """
        MAIN (funding account), TRADE (spot trading account)
        """
        self.obj['accountType'] = value
        return self

    def build(self) -> PurchaseReq:
        return PurchaseReq(**self.obj)
