# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetPublicFundingHistoryReq(BaseModel):
    """
    GetPublicFundingHistoryReq

    Attributes:
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        from_ (int): Begin time (milisecond) 
        to (int): End time (milisecond) 
    """

    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    from_: Optional[int] = Field(default=None,
                                 description="Begin time (milisecond) ",
                                 alias="from")
    to: Optional[int] = Field(default=None,
                              description="End time (milisecond) ")

    __properties: ClassVar[List[str]] = ["symbol", "from", "to"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetPublicFundingHistoryReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetPublicFundingHistoryReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "from": obj.get("from"),
            "to": obj.get("to")
        })
        return _obj


class GetPublicFundingHistoryReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> GetPublicFundingHistoryReqBuilder:
        """
        Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        """
        self.obj['symbol'] = value
        return self

    def set_from_(self, value: int) -> GetPublicFundingHistoryReqBuilder:
        """
        Begin time (milisecond) 
        """
        self.obj['from'] = value
        return self

    def set_to(self, value: int) -> GetPublicFundingHistoryReqBuilder:
        """
        End time (milisecond) 
        """
        self.obj['to'] = value
        return self

    def build(self) -> GetPublicFundingHistoryReq:
        return GetPublicFundingHistoryReq(**self.obj)
