# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class AllOrderEvent(BaseModel):
    """
    AllOrderEvent

    Attributes:
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-221752070) 
        order_type (OrderTypeEnum): User-specified order type
        side (SideEnum): buy or sell
        canceled_size (str): Cumulative number of cancellations
        order_id (str): The unique order id generated by the trading system
        margin_mode (MarginModeEnum): Margin Mode
        type (TypeEnum): Order Type
        order_time (int): Order time(Nanosecond)
        size (str): User-specified order size
        filled_size (str): Cumulative number of filled
        price (str): Price
        remain_size (str): Remain size
        status (StatusEnum): Order Status
        ts (int): Push time(Nanosecond)
        liquidity (LiquidityEnum): Actual transaction order type, If the counterparty order is an [Hidden/Iceberg Order](https://www.kucoin.com/docs-new/doc-338146), even if it is a maker order, this param will be displayed as taker. For actual trading fee, please refer to the **feeType** 
        fee_type (FeeTypeEnum): Actual Fee Type
        match_price (str): Match Price(when the type is \"match\")
        match_size (str): Match Size (when the type is \"match\")
        trade_id (str): Trade id, it is generated by Matching engine.
        old_size (str): The size before order update
        client_oid (str): Client Order Id，The ClientOid field is a unique ID created by the user
        trade_type (TradeTypeEnum): normal order or liquid order
    """

    class OrderTypeEnum(Enum):
        """
        Attributes:
            LIMIT: limit
            MARKET: market
        """
        LIMIT = 'limit'
        MARKET = 'market'

    class SideEnum(Enum):
        """
        Attributes:
            BUY: buy
            SELL: sell
        """
        BUY = 'buy'
        SELL = 'sell'

    class MarginModeEnum(Enum):
        """
        Attributes:
            ISOLATED: Isolated Margin
            CROSS: Cross Margin
        """
        ISOLATED = 'ISOLATED'
        CROSS = 'CROSS'

    class TypeEnum(Enum):
        """
        Attributes:
            OPEN: the order is in the order book（maker order）
            MATCH: the message sent when the order is match,  1. When the status is open and the type is match, it is a maker match.  2. When the status is match and the type is match, it is a taker match.
            UPDATE: The message sent due to the order being modified: STP triggering, partial cancellation of the order. Includes these three situations:  1. When the status is open and the type is update: partial amounts of the order have been canceled, or STP triggers  2. When the status is match and the type is update: STP triggers  3. When the status is done and the type is update: partial amounts of the order have been filled and the unfilled part got canceled, or STP is triggered.
            FILLED: The message sent when the status of the order changes to DONE after the transaction
            CANCELED: The message sent when the status of the order changes to DONE due to being canceled
        """
        OPEN = 'open'
        MATCH = 'match'
        UPDATE = 'update'
        FILLED = 'filled'
        CANCELED = 'canceled'

    class StatusEnum(Enum):
        """
        Attributes:
            OPEN: the order is in the order book（maker order）
            MATCH: when taker order executes with orders in the order book, the taker order status is “match”
            DONE: the order is fully executed successfully
        """
        OPEN = 'open'
        MATCH = 'match'
        DONE = 'done'

    class LiquidityEnum(Enum):
        """
        Attributes:
            TAKER: taker
            MAKER: maker
        """
        TAKER = 'taker'
        MAKER = 'maker'

    class FeeTypeEnum(Enum):
        """
        Attributes:
            TAKER_FEE: takerFee
            MAKER_FEE: makerFee
        """
        TAKER_FEE = 'takerFee'
        MAKER_FEE = 'makerFee'

    class TradeTypeEnum(Enum):
        """
        Attributes:
            TRADE: Normal trade order
            LIQUID: Liquid order, except type&#x3D;update, all other types will be pushed
        """
        TRADE = 'trade'
        LIQUID = 'liquid'

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-221752070) "
    )
    order_type: Optional[OrderTypeEnum] = Field(
        default=None,
        description="User-specified order type",
        alias="orderType")
    side: Optional[SideEnum] = Field(default=None, description="buy or sell")
    canceled_size: Optional[str] = Field(
        default=None,
        description="Cumulative number of cancellations",
        alias="canceledSize")
    order_id: Optional[str] = Field(
        default=None,
        description="The unique order id generated by the trading system",
        alias="orderId")
    margin_mode: Optional[MarginModeEnum] = Field(default=None,
                                                  description="Margin Mode",
                                                  alias="marginMode")
    type: Optional[TypeEnum] = Field(default=None, description="Order Type")
    order_time: Optional[int] = Field(default=None,
                                      description="Order time(Nanosecond)",
                                      alias="orderTime")
    size: Optional[str] = Field(default=None,
                                description="User-specified order size")
    filled_size: Optional[str] = Field(
        default=None,
        description="Cumulative number of filled",
        alias="filledSize")
    price: Optional[str] = Field(default=None, description="Price")
    remain_size: Optional[str] = Field(default=None,
                                       description="Remain size",
                                       alias="remainSize")
    status: Optional[StatusEnum] = Field(default=None,
                                         description="Order Status")
    ts: Optional[int] = Field(default=None,
                              description="Push time(Nanosecond)")
    liquidity: Optional[LiquidityEnum] = Field(
        default=None,
        description=
        "Actual transaction order type, If the counterparty order is an [Hidden/Iceberg Order](https://www.kucoin.com/docs-new/doc-338146), even if it is a maker order, this param will be displayed as taker. For actual trading fee, please refer to the **feeType** "
    )
    fee_type: Optional[FeeTypeEnum] = Field(default=None,
                                            description="Actual Fee Type",
                                            alias="feeType")
    match_price: Optional[str] = Field(
        default=None,
        description="Match Price(when the type is \"match\")",
        alias="matchPrice")
    match_size: Optional[str] = Field(
        default=None,
        description="Match Size (when the type is \"match\")",
        alias="matchSize")
    trade_id: Optional[str] = Field(
        default=None,
        description="Trade id, it is generated by Matching engine.",
        alias="tradeId")
    old_size: Optional[str] = Field(default=None,
                                    description="The size before order update",
                                    alias="oldSize")
    client_oid: Optional[str] = Field(
        default=None,
        description=
        "Client Order Id，The ClientOid field is a unique ID created by the user",
        alias="clientOid")
    trade_type: Optional[TradeTypeEnum] = Field(
        default=None,
        description="normal order or liquid order",
        alias="tradeType")

    __properties: ClassVar[List[str]] = [
        "symbol", "orderType", "side", "canceledSize", "orderId", "marginMode",
        "type", "orderTime", "size", "filledSize", "price", "remainSize",
        "status", "ts", "liquidity", "feeType", "matchPrice", "matchSize",
        "tradeId", "oldSize", "clientOid", "tradeType"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AllOrderEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[AllOrderEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "orderType": obj.get("orderType"),
            "side": obj.get("side"),
            "canceledSize": obj.get("canceledSize"),
            "orderId": obj.get("orderId"),
            "marginMode": obj.get("marginMode"),
            "type": obj.get("type"),
            "orderTime": obj.get("orderTime"),
            "size": obj.get("size"),
            "filledSize": obj.get("filledSize"),
            "price": obj.get("price"),
            "remainSize": obj.get("remainSize"),
            "status": obj.get("status"),
            "ts": obj.get("ts"),
            "liquidity": obj.get("liquidity"),
            "feeType": obj.get("feeType"),
            "matchPrice": obj.get("matchPrice"),
            "matchSize": obj.get("matchSize"),
            "tradeId": obj.get("tradeId"),
            "oldSize": obj.get("oldSize"),
            "clientOid": obj.get("clientOid"),
            "tradeType": obj.get("tradeType")
        })
        return _obj


AllOrderEventCallback = Callable[[str, str, AllOrderEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (AllOrderEvent): event data
"""


class AllOrderEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: AllOrderEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = AllOrderEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
