# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from .model_cross_leverage_data_value import CrossLeverageDataValue
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class CrossLeverageEvent(BaseModel):
    """
    CrossLeverageEvent

    Attributes:
        data (dict[str, CrossLeverageDataValue]): 
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    data: Optional[Dict[str, CrossLeverageDataValue]] = None

    __properties: ClassVar[List[str]] = ["data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[CrossLeverageEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in data (dict)
        _field_dict = {}
        if self.data:
            for _key_data in self.data:
                if self.data[_key_data]:
                    _field_dict[_key_data] = self.data[_key_data].to_dict()
            _dict['data'] = _field_dict
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[CrossLeverageEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "data":
            dict((_k, CrossLeverageDataValue.from_dict(_v))
                 for _k, _v in obj["data"].items())
            if obj.get("data") is not None else None
        })
        return _obj


CrossLeverageEventCallback = Callable[[str, str, CrossLeverageEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (CrossLeverageEvent): event data
"""


class CrossLeverageEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: CrossLeverageEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = CrossLeverageEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
