# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class ExecutionEvent(BaseModel):
    """
    ExecutionEvent

    Attributes:
        symbol (str): 
        sequence (int): 
        side (str): 
        size (int): 
        price (str): 
        taker_order_id (str): 
        maker_order_id (str): 
        trade_id (str): 
        ts (int): 
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    symbol: Optional[str] = None
    sequence: Optional[int] = None
    side: Optional[str] = None
    size: Optional[int] = None
    price: Optional[str] = None
    taker_order_id: Optional[str] = Field(default=None, alias="takerOrderId")
    maker_order_id: Optional[str] = Field(default=None, alias="makerOrderId")
    trade_id: Optional[str] = Field(default=None, alias="tradeId")
    ts: Optional[int] = None

    __properties: ClassVar[List[str]] = [
        "symbol", "sequence", "side", "size", "price", "takerOrderId",
        "makerOrderId", "tradeId", "ts"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[ExecutionEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[ExecutionEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "sequence": obj.get("sequence"),
            "side": obj.get("side"),
            "size": obj.get("size"),
            "price": obj.get("price"),
            "takerOrderId": obj.get("takerOrderId"),
            "makerOrderId": obj.get("makerOrderId"),
            "tradeId": obj.get("tradeId"),
            "ts": obj.get("ts")
        })
        return _obj


ExecutionEventCallback = Callable[[str, str, ExecutionEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (ExecutionEvent): event data
"""


class ExecutionEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: ExecutionEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = ExecutionEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
