# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetInterestRateIndexDataList(BaseModel):
    """
    GetInterestRateIndexDataList

    Attributes:
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: fundingBaseSymbol, fundingQuoteSymbol, fundingBaseSymbol1M, fundingQuoteSymbol1M](https://www.kucoin.com/docs-new/api-3470220) 
        granularity (int): Granularity (milisecond)
        time_point (int): Timestamp(milisecond)
        value (float): Interest rate value
    """

    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: fundingBaseSymbol, fundingQuoteSymbol, fundingBaseSymbol1M, fundingQuoteSymbol1M](https://www.kucoin.com/docs-new/api-3470220) "
    )
    granularity: Optional[int] = Field(default=None,
                                       description="Granularity (milisecond)")
    time_point: Optional[int] = Field(default=None,
                                      description="Timestamp(milisecond)",
                                      alias="timePoint")
    value: Optional[float] = Field(default=None,
                                   description="Interest rate value")

    __properties: ClassVar[List[str]] = [
        "symbol", "granularity", "timePoint", "value"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[GetInterestRateIndexDataList]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[GetInterestRateIndexDataList]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "granularity": obj.get("granularity"),
            "timePoint": obj.get("timePoint"),
            "value": obj.get("value")
        })
        return _obj
