# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_spot_index_price_data_list_decomposion_list import GetSpotIndexPriceDataListDecomposionList


class GetSpotIndexPriceDataList(BaseModel):
    """
    GetSpotIndexPriceDataList

    Attributes:
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: indexSymbol](https://www.kucoin.com/docs-new/api-3470220) 
        granularity (int): Granularity (milisecond)
        time_point (int): Timestamp (milisecond)
        value (float): Index Value
        decomposion_list (list[GetSpotIndexPriceDataListDecomposionList]): Component List
    """

    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: indexSymbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    granularity: Optional[int] = Field(default=None,
                                       description="Granularity (milisecond)")
    time_point: Optional[int] = Field(default=None,
                                      description="Timestamp (milisecond)",
                                      alias="timePoint")
    value: Optional[float] = Field(default=None, description="Index Value")
    decomposion_list: Optional[
        List[GetSpotIndexPriceDataListDecomposionList]] = Field(
            default=None,
            description="Component List",
            alias="decomposionList")

    __properties: ClassVar[List[str]] = [
        "symbol", "granularity", "timePoint", "value", "decomposionList"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSpotIndexPriceDataList]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in decomposion_list (list)
        _items = []
        if self.decomposion_list:
            for _item_decomposion_list in self.decomposion_list:
                if _item_decomposion_list:
                    _items.append(_item_decomposion_list.to_dict())
            _dict['decomposionList'] = _items
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetSpotIndexPriceDataList]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "granularity":
            obj.get("granularity"),
            "timePoint":
            obj.get("timePoint"),
            "value":
            obj.get("value"),
            "decomposionList": [
                GetSpotIndexPriceDataListDecomposionList.from_dict(_item)
                for _item in obj["decomposionList"]
            ] if obj.get("decomposionList") is not None else None
        })
        return _obj
