# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetTradeHistoryData(BaseModel):
    """
    GetTradeHistoryData

    Attributes:
        sequence (int): Sequence number
        contract_id (int): Deprecated param
        trade_id (str): Transaction ID
        maker_order_id (str): Maker order ID
        taker_order_id (str): Taker order ID
        ts (int): Filled timestamp(nanosecond)
        size (int): Filled amount
        price (str): Filled price
        side (SideEnum): Filled side, The trade side indicates the taker order side. A taker order is the order that was matched with orders opened on the order book.
    """

    class SideEnum(Enum):
        """
        Attributes:
            BUY: buy
            SELL: sell
        """
        BUY = 'buy'
        SELL = 'sell'

    sequence: Optional[int] = Field(default=None,
                                    description="Sequence number")
    contract_id: Optional[int] = Field(default=None,
                                       description="Deprecated param",
                                       alias="contractId")
    trade_id: Optional[str] = Field(default=None,
                                    description="Transaction ID",
                                    alias="tradeId")
    maker_order_id: Optional[str] = Field(default=None,
                                          description="Maker order ID",
                                          alias="makerOrderId")
    taker_order_id: Optional[str] = Field(default=None,
                                          description="Taker order ID",
                                          alias="takerOrderId")
    ts: Optional[int] = Field(default=None,
                              description="Filled timestamp(nanosecond)")
    size: Optional[int] = Field(default=None, description="Filled amount")
    price: Optional[str] = Field(default=None, description="Filled price")
    side: Optional[SideEnum] = Field(
        default=None,
        description=
        "Filled side, The trade side indicates the taker order side. A taker order is the order that was matched with orders opened on the order book."
    )

    __properties: ClassVar[List[str]] = [
        "sequence", "contractId", "tradeId", "makerOrderId", "takerOrderId",
        "ts", "size", "price", "side"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetTradeHistoryData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetTradeHistoryData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sequence": obj.get("sequence"),
            "contractId": obj.get("contractId"),
            "tradeId": obj.get("tradeId"),
            "makerOrderId": obj.get("makerOrderId"),
            "takerOrderId": obj.get("takerOrderId"),
            "ts": obj.get("ts"),
            "size": obj.get("size"),
            "price": obj.get("price"),
            "side": obj.get("side")
        })
        return _obj
