# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetRecentClosedOrdersData(BaseModel):
    """
    GetRecentClosedOrdersData

    Attributes:
        id (str): Order ID
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        type (str): Order type, market order or limit order
        side (str): Transaction side
        price (str): Order price
        size (int): Order quantity
        value (str): Order value 
        deal_value (str): Executed size of funds 
        deal_size (int): Executed quantity 
        stp (str): self trade prevention
        stop (str): Stop order type (stop limit or stop market) 
        stop_price_type (str): Trigger price type of stop orders 
        stop_triggered (bool): Mark to show whether the stop order is triggered
        stop_price (int): Trigger price of stop orders 
        time_in_force (str): Time in force policy type 
        post_only (bool): Mark of post only 
        hidden (bool): Mark of the hidden order 
        iceberg (bool): Mark of the iceberg order 
        leverage (str): Leverage of the order 
        force_hold (bool): A mark to forcely hold the funds for an order 
        close_order (bool): A mark to close the position 
        visible_size (int): Visible size of the iceberg order 
        client_oid (str): Unique order id created by users to identify their orders 
        remark (str): Remark of the order 
        tags (str): tag order source 
        is_active (bool): Mark of the active orders 
        cancel_exist (bool): Mark of the canceled orders 
        created_at (int): Time the order created 
        updated_at (int): last update time 
        end_at (int): End time 
        order_time (int): Order create time in nanosecond 
        settle_currency (str): settlement currency 
        margin_mode (str): Margin mode: ISOLATED (isolated), CROSS (cross margin). 
        avg_deal_price (str): Average transaction price, forward contract average transaction price = sum (transaction value) / sum (transaction quantity), reverse contract average transaction price = sum (transaction quantity) / sum (transaction value). Transaction quantity = lots * multiplier 
        filled_size (int): Value of the executed orders 
        filled_value (str): Executed order quantity 
        status (str): order status: “open” or “done” 
        reduce_only (bool): A mark to reduce the position size only 
    """

    id: Optional[str] = Field(default=None, description="Order ID")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    type: Optional[str] = Field(
        default=None, description="Order type, market order or limit order")
    side: Optional[str] = Field(default=None, description="Transaction side")
    price: Optional[str] = Field(default=None, description="Order price")
    size: Optional[int] = Field(default=None, description="Order quantity")
    value: Optional[str] = Field(default=None, description="Order value ")
    deal_value: Optional[str] = Field(default=None,
                                      description="Executed size of funds ",
                                      alias="dealValue")
    deal_size: Optional[int] = Field(default=None,
                                     description="Executed quantity ",
                                     alias="dealSize")
    stp: Optional[str] = Field(default=None,
                               description="self trade prevention")
    stop: Optional[str] = Field(
        default=None,
        description="Stop order type (stop limit or stop market) ")
    stop_price_type: Optional[str] = Field(
        default=None,
        description="Trigger price type of stop orders ",
        alias="stopPriceType")
    stop_triggered: Optional[bool] = Field(
        default=None,
        description="Mark to show whether the stop order is triggered",
        alias="stopTriggered")
    stop_price: Optional[int] = Field(
        default=None,
        description="Trigger price of stop orders ",
        alias="stopPrice")
    time_in_force: Optional[str] = Field(
        default=None,
        description="Time in force policy type ",
        alias="timeInForce")
    post_only: Optional[bool] = Field(default=None,
                                      description="Mark of post only ",
                                      alias="postOnly")
    hidden: Optional[bool] = Field(default=None,
                                   description="Mark of the hidden order ")
    iceberg: Optional[bool] = Field(default=None,
                                    description="Mark of the iceberg order ")
    leverage: Optional[str] = Field(default=None,
                                    description="Leverage of the order ")
    force_hold: Optional[bool] = Field(
        default=None,
        description="A mark to forcely hold the funds for an order ",
        alias="forceHold")
    close_order: Optional[bool] = Field(
        default=None,
        description="A mark to close the position ",
        alias="closeOrder")
    visible_size: Optional[int] = Field(
        default=None,
        description="Visible size of the iceberg order ",
        alias="visibleSize")
    client_oid: Optional[str] = Field(
        default=None,
        description=
        "Unique order id created by users to identify their orders ",
        alias="clientOid")
    remark: Optional[str] = Field(default=None,
                                  description="Remark of the order ")
    tags: Optional[str] = Field(default=None, description="tag order source ")
    is_active: Optional[bool] = Field(default=None,
                                      description="Mark of the active orders ",
                                      alias="isActive")
    cancel_exist: Optional[bool] = Field(
        default=None,
        description="Mark of the canceled orders ",
        alias="cancelExist")
    created_at: Optional[int] = Field(default=None,
                                      description="Time the order created ",
                                      alias="createdAt")
    updated_at: Optional[int] = Field(default=None,
                                      description="last update time ",
                                      alias="updatedAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time ",
                                  alias="endAt")
    order_time: Optional[int] = Field(
        default=None,
        description="Order create time in nanosecond ",
        alias="orderTime")
    settle_currency: Optional[str] = Field(default=None,
                                           description="settlement currency ",
                                           alias="settleCurrency")
    margin_mode: Optional[str] = Field(
        default=None,
        description="Margin mode: ISOLATED (isolated), CROSS (cross margin). ",
        alias="marginMode")
    avg_deal_price: Optional[str] = Field(
        default=None,
        description=
        "Average transaction price, forward contract average transaction price = sum (transaction value) / sum (transaction quantity), reverse contract average transaction price = sum (transaction quantity) / sum (transaction value). Transaction quantity = lots * multiplier ",
        alias="avgDealPrice")
    filled_size: Optional[int] = Field(
        default=None,
        description="Value of the executed orders ",
        alias="filledSize")
    filled_value: Optional[str] = Field(default=None,
                                        description="Executed order quantity ",
                                        alias="filledValue")
    status: Optional[str] = Field(
        default=None, description="order status: “open” or “done” ")
    reduce_only: Optional[bool] = Field(
        default=None,
        description="A mark to reduce the position size only ",
        alias="reduceOnly")

    __properties: ClassVar[List[str]] = [
        "id", "symbol", "type", "side", "price", "size", "value", "dealValue",
        "dealSize", "stp", "stop", "stopPriceType", "stopTriggered",
        "stopPrice", "timeInForce", "postOnly", "hidden", "iceberg",
        "leverage", "forceHold", "closeOrder", "visibleSize", "clientOid",
        "remark", "tags", "isActive", "cancelExist", "createdAt", "updatedAt",
        "endAt", "orderTime", "settleCurrency", "marginMode", "avgDealPrice",
        "filledSize", "filledValue", "status", "reduceOnly"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetRecentClosedOrdersData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetRecentClosedOrdersData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "symbol": obj.get("symbol"),
            "type": obj.get("type"),
            "side": obj.get("side"),
            "price": obj.get("price"),
            "size": obj.get("size"),
            "value": obj.get("value"),
            "dealValue": obj.get("dealValue"),
            "dealSize": obj.get("dealSize"),
            "stp": obj.get("stp"),
            "stop": obj.get("stop"),
            "stopPriceType": obj.get("stopPriceType"),
            "stopTriggered": obj.get("stopTriggered"),
            "stopPrice": obj.get("stopPrice"),
            "timeInForce": obj.get("timeInForce"),
            "postOnly": obj.get("postOnly"),
            "hidden": obj.get("hidden"),
            "iceberg": obj.get("iceberg"),
            "leverage": obj.get("leverage"),
            "forceHold": obj.get("forceHold"),
            "closeOrder": obj.get("closeOrder"),
            "visibleSize": obj.get("visibleSize"),
            "clientOid": obj.get("clientOid"),
            "remark": obj.get("remark"),
            "tags": obj.get("tags"),
            "isActive": obj.get("isActive"),
            "cancelExist": obj.get("cancelExist"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "endAt": obj.get("endAt"),
            "orderTime": obj.get("orderTime"),
            "settleCurrency": obj.get("settleCurrency"),
            "marginMode": obj.get("marginMode"),
            "avgDealPrice": obj.get("avgDealPrice"),
            "filledSize": obj.get("filledSize"),
            "filledValue": obj.get("filledValue"),
            "status": obj.get("status"),
            "reduceOnly": obj.get("reduceOnly")
        })
        return _obj
