# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated


class GetTradeHistoryReq(BaseModel):
    """
    GetTradeHistoryReq

    Attributes:
        order_id (str): List fills for a specific order only (If you specify orderId, other parameters can be ignored)
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        side (SideEnum): Order side
        type (TypeEnum): Order Type
        trade_types (str): Transaction type: trade, adl, liquid, settlement. Supports querying multiple types at the same time, separated by commas. Query all type when empty
        start_at (int): Start time (milisecond)
        end_at (int): End time (milisecond)
        current_page (int): Current request page, The default currentPage is 1
        page_size (int): pageSize, The default pageSize is 50, The maximum cannot exceed 1000
    """

    class SideEnum(Enum):
        """
        Attributes:
            BUY: buy
            SELL: sell
        """
        BUY = 'buy'
        SELL = 'sell'

    class TypeEnum(Enum):
        """
        Attributes:
            LIMIT: Limit order
            MARKET: Market order
            LIMIT_STOP: Stop limit order
            MARKET_STOP: Stop Market order
        """
        LIMIT = 'limit'
        MARKET = 'market'
        LIMIT_STOP = 'limit_stop'
        MARKET_STOP = 'market_stop'

    order_id: Optional[str] = Field(
        default=None,
        description=
        "List fills for a specific order only (If you specify orderId, other parameters can be ignored)",
        alias="orderId")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    side: Optional[SideEnum] = Field(default=None, description="Order side")
    type: Optional[TypeEnum] = Field(default=None, description="Order Type")
    trade_types: Optional[str] = Field(
        default=None,
        description=
        "Transaction type: trade, adl, liquid, settlement. Supports querying multiple types at the same time, separated by commas. Query all type when empty",
        alias="tradeTypes")
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milisecond)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milisecond)",
                                  alias="endAt")
    current_page: Optional[int] = Field(
        default=1,
        description="Current request page, The default currentPage is 1",
        alias="currentPage")
    page_size: Optional[Annotated[int, Field(le=1000, strict=True)]] = Field(
        default=50,
        description=
        "pageSize, The default pageSize is 50, The maximum cannot exceed 1000",
        alias="pageSize")

    __properties: ClassVar[List[str]] = [
        "orderId", "symbol", "side", "type", "tradeTypes", "startAt", "endAt",
        "currentPage", "pageSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetTradeHistoryReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetTradeHistoryReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId":
            obj.get("orderId"),
            "symbol":
            obj.get("symbol"),
            "side":
            obj.get("side"),
            "type":
            obj.get("type"),
            "tradeTypes":
            obj.get("tradeTypes"),
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt"),
            "currentPage":
            obj.get("currentPage")
            if obj.get("currentPage") is not None else 1,
            "pageSize":
            obj.get("pageSize") if obj.get("pageSize") is not None else 50
        })
        return _obj


class GetTradeHistoryReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_order_id(self, value: str) -> GetTradeHistoryReqBuilder:
        """
        List fills for a specific order only (If you specify orderId, other parameters can be ignored)
        """
        self.obj['orderId'] = value
        return self

    def set_symbol(self, value: str) -> GetTradeHistoryReqBuilder:
        """
        Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        """
        self.obj['symbol'] = value
        return self

    def set_side(
            self,
            value: GetTradeHistoryReq.SideEnum) -> GetTradeHistoryReqBuilder:
        """
        Order side
        """
        self.obj['side'] = value
        return self

    def set_type(
            self,
            value: GetTradeHistoryReq.TypeEnum) -> GetTradeHistoryReqBuilder:
        """
        Order Type
        """
        self.obj['type'] = value
        return self

    def set_trade_types(self, value: str) -> GetTradeHistoryReqBuilder:
        """
        Transaction type: trade, adl, liquid, settlement. Supports querying multiple types at the same time, separated by commas. Query all type when empty
        """
        self.obj['tradeTypes'] = value
        return self

    def set_start_at(self, value: int) -> GetTradeHistoryReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetTradeHistoryReqBuilder:
        """
        End time (milisecond)
        """
        self.obj['endAt'] = value
        return self

    def set_current_page(self, value: int) -> GetTradeHistoryReqBuilder:
        """
        Current request page, The default currentPage is 1
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(self, value: int) -> GetTradeHistoryReqBuilder:
        """
        pageSize, The default pageSize is 50, The maximum cannot exceed 1000
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetTradeHistoryReq:
        return GetTradeHistoryReq(**self.obj)
