# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetLoanMarketData(BaseModel):
    """
    GetLoanMarketData

    Attributes:
        currency (str): Currency
        purchase_enable (bool): Whether purchase is supported.
        redeem_enable (bool): Whether redeem is supported.
        increment (str): Increment precision for purchase and redemption
        min_purchase_size (str): Minimum purchase amount
        min_interest_rate (str): Minimum lending rate
        max_interest_rate (str): Maximum lending rate
        interest_increment (str): Increment precision for interest; default is 0.0001
        max_purchase_size (str): Maximum purchase amount
        market_interest_rate (str): Latest market lending rate
        auto_purchase_enable (bool): Whether to allow automatic purchase: true: on, false: off
    """

    currency: Optional[str] = Field(default=None, description="Currency")
    purchase_enable: Optional[bool] = Field(
        default=None,
        description="Whether purchase is supported.",
        alias="purchaseEnable")
    redeem_enable: Optional[bool] = Field(
        default=None,
        description="Whether redeem is supported.",
        alias="redeemEnable")
    increment: Optional[str] = Field(
        default=None,
        description="Increment precision for purchase and redemption")
    min_purchase_size: Optional[str] = Field(
        default=None,
        description="Minimum purchase amount",
        alias="minPurchaseSize")
    min_interest_rate: Optional[str] = Field(
        default=None,
        description="Minimum lending rate",
        alias="minInterestRate")
    max_interest_rate: Optional[str] = Field(
        default=None,
        description="Maximum lending rate",
        alias="maxInterestRate")
    interest_increment: Optional[str] = Field(
        default='0.0001',
        description="Increment precision for interest; default is 0.0001",
        alias="interestIncrement")
    max_purchase_size: Optional[str] = Field(
        default=None,
        description="Maximum purchase amount",
        alias="maxPurchaseSize")
    market_interest_rate: Optional[str] = Field(
        default=None,
        description="Latest market lending rate",
        alias="marketInterestRate")
    auto_purchase_enable: Optional[bool] = Field(
        default=None,
        description="Whether to allow automatic purchase: true: on, false: off",
        alias="autoPurchaseEnable")

    __properties: ClassVar[List[str]] = [
        "currency", "purchaseEnable", "redeemEnable", "increment",
        "minPurchaseSize", "minInterestRate", "maxInterestRate",
        "interestIncrement", "maxPurchaseSize", "marketInterestRate",
        "autoPurchaseEnable"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetLoanMarketData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str, Any]]) -> Optional[GetLoanMarketData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "purchaseEnable":
            obj.get("purchaseEnable"),
            "redeemEnable":
            obj.get("redeemEnable"),
            "increment":
            obj.get("increment"),
            "minPurchaseSize":
            obj.get("minPurchaseSize"),
            "minInterestRate":
            obj.get("minInterestRate"),
            "maxInterestRate":
            obj.get("maxInterestRate"),
            "interestIncrement":
            obj.get("interestIncrement")
            if obj.get("interestIncrement") is not None else '0.0001',
            "maxPurchaseSize":
            obj.get("maxPurchaseSize"),
            "marketInterestRate":
            obj.get("marketInterestRate"),
            "autoPurchaseEnable":
            obj.get("autoPurchaseEnable")
        })
        return _obj
