# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class ModifyLeverageReq(BaseModel):
    """
    ModifyLeverageReq

    Attributes:
        symbol (str): symbol, mandatory for isolated margin account
        is_isolated (bool): true-isolated, false-cross; default is false
        leverage (str): New leverage multiplier. Must be greater than 1 and up to two decimal places, and cannot be less than the user's current debt leverage or greater than the system's maximum leverage
    """

    symbol: Optional[str] = Field(
        default=None,
        description="symbol, mandatory for isolated margin account")
    is_isolated: Optional[bool] = Field(
        default=False,
        description="true-isolated, false-cross; default is false",
        alias="isIsolated")
    leverage: Optional[str] = Field(
        default=None,
        description=
        "New leverage multiplier. Must be greater than 1 and up to two decimal places, and cannot be less than the user's current debt leverage or greater than the system's maximum leverage"
    )

    __properties: ClassVar[List[str]] = ["symbol", "isIsolated", "leverage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[ModifyLeverageReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str, Any]]) -> Optional[ModifyLeverageReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "isIsolated":
            obj.get("isIsolated")
            if obj.get("isIsolated") is not None else False,
            "leverage":
            obj.get("leverage")
        })
        return _obj


class ModifyLeverageReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> ModifyLeverageReqBuilder:
        """
        symbol, mandatory for isolated margin account
        """
        self.obj['symbol'] = value
        return self

    def set_is_isolated(self, value: bool) -> ModifyLeverageReqBuilder:
        """
        true-isolated, false-cross; default is false
        """
        self.obj['isIsolated'] = value
        return self

    def set_leverage(self, value: str) -> ModifyLeverageReqBuilder:
        """
        New leverage multiplier. Must be greater than 1 and up to two decimal places, and cannot be less than the user's current debt leverage or greater than the system's maximum leverage
        """
        self.obj['leverage'] = value
        return self

    def build(self) -> ModifyLeverageReq:
        return ModifyLeverageReq(**self.obj)
