# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketService
from .model_index_price_event import IndexPriceEventCallback, IndexPriceEventCallbackWrapper
from .model_mark_price_event import MarkPriceEventCallback, MarkPriceEventCallbackWrapper
from typing import List


class MarginPublicWS(ABC):

    @abstractmethod
    def index_price(self, symbol: List[str],
                    callback: IndexPriceEventCallback) -> str:
        """
        summary: Index Price
        description: Subscribe to this topic to get the index price for the margin trading. The following ticker symbols are supported: List of currently supported symbol.
        push frequency: once every 1s
        """
        pass

    @abstractmethod
    def mark_price(self, symbol: List[str],
                   callback: MarkPriceEventCallback) -> str:
        """
        summary: Mark Price
        description: Subscribe to this topic to get the mark price for margin trading.The following ticker symbols are supported: List of currently supported symbol
        push frequency: once every 1s
        """
        pass

    @abstractmethod
    def unsubscribe(self, id: str):
        pass

    @abstractmethod
    def start(self):
        pass

    @abstractmethod
    def stop(self):
        pass


class MarginPublicWSImpl(MarginPublicWS):

    def __init__(self, transport: WebSocketService):
        self.transport = transport

    def index_price(self, symbol: List[str],
                    callback: IndexPriceEventCallback) -> str:
        topic_prefix = "/indicator/index"

        args = symbol

        return self.transport.subscribe(
            topic_prefix, args, IndexPriceEventCallbackWrapper(callback))

    def mark_price(self, symbol: List[str],
                   callback: MarkPriceEventCallback) -> str:
        topic_prefix = "/indicator/markPrice"

        args = symbol

        return self.transport.subscribe(
            topic_prefix, args, MarkPriceEventCallbackWrapper(callback))

    def unsubscribe(self, id: str):
        self.transport.unsubscribe(id)

    def start(self):
        self.transport.start()

    def stop(self):
        self.transport.stop()
