# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetTradeHistoryItems(BaseModel):
    """
    GetTradeHistoryItems

    Attributes:
        id (int): Id of transaction detail
        symbol (str): symbol
        trade_id (int): Trade Id, symbol latitude increment
        order_id (str): The unique order id generated by the trading system
        counter_order_id (str): Counterparty order Id
        side (SideEnum): Buy or sell
        liquidity (LiquidityEnum): Liquidity type: taker or maker
        force_taker (bool): 
        price (str): Order price
        size (str): Order size
        funds (str): Order Funds
        fee (str): [Handling fees](https://www.kucoin.com/docs-new/api-5327739)
        fee_rate (str): Fee rate 
        fee_currency (str): currency used to calculate trading fee
        stop (str): Take Profit and Stop Loss type, currently HFT does not support the Take Profit and Stop Loss type, so it is empty
        trade_type (str): Trade type, redundancy param
        tax (str): Users in some regions need query this field
        tax_rate (str): Tax Rate, Users in some regions need query this field
        type (TypeEnum): Specify if the order is an 'limit' order or 'market' order. 
        created_at (int): 
    """

    class SideEnum(Enum):
        """
        Attributes:
            BUY: 
            SELL: 
        """
        BUY = 'buy'
        SELL = 'sell'

    class LiquidityEnum(Enum):
        """
        Attributes:
            TAKER: 
            MAKER: 
        """
        TAKER = 'taker'
        MAKER = 'maker'

    class TypeEnum(Enum):
        """
        Attributes:
            LIMIT: 
            MARKET: 
        """
        LIMIT = 'limit'
        MARKET = 'market'

    id: Optional[int] = Field(default=None,
                              description="Id of transaction detail")
    symbol: Optional[str] = Field(default=None, description="symbol")
    trade_id: Optional[int] = Field(
        default=None,
        description="Trade Id, symbol latitude increment",
        alias="tradeId")
    order_id: Optional[str] = Field(
        default=None,
        description="The unique order id generated by the trading system",
        alias="orderId")
    counter_order_id: Optional[str] = Field(
        default=None,
        description="Counterparty order Id",
        alias="counterOrderId")
    side: Optional[SideEnum] = Field(default=None, description="Buy or sell")
    liquidity: Optional[LiquidityEnum] = Field(
        default=None, description="Liquidity type: taker or maker")
    force_taker: Optional[bool] = Field(default=None, alias="forceTaker")
    price: Optional[str] = Field(default=None, description="Order price")
    size: Optional[str] = Field(default=None, description="Order size")
    funds: Optional[str] = Field(default=None, description="Order Funds")
    fee: Optional[str] = Field(
        default=None,
        description=
        "[Handling fees](https://www.kucoin.com/docs-new/api-5327739)")
    fee_rate: Optional[str] = Field(default=None,
                                    description="Fee rate ",
                                    alias="feeRate")
    fee_currency: Optional[str] = Field(
        default=None,
        description="currency used to calculate trading fee",
        alias="feeCurrency")
    stop: Optional[str] = Field(
        default=None,
        description=
        "Take Profit and Stop Loss type, currently HFT does not support the Take Profit and Stop Loss type, so it is empty"
    )
    trade_type: Optional[str] = Field(
        default=None,
        description="Trade type, redundancy param",
        alias="tradeType")
    tax: Optional[str] = Field(
        default=None,
        description="Users in some regions need query this field")
    tax_rate: Optional[str] = Field(
        default=None,
        description="Tax Rate, Users in some regions need query this field",
        alias="taxRate")
    type: Optional[TypeEnum] = Field(
        default=None,
        description=
        "Specify if the order is an 'limit' order or 'market' order. ")
    created_at: Optional[int] = Field(default=None, alias="createdAt")

    __properties: ClassVar[List[str]] = [
        "id", "symbol", "tradeId", "orderId", "counterOrderId", "side",
        "liquidity", "forceTaker", "price", "size", "funds", "fee", "feeRate",
        "feeCurrency", "stop", "tradeType", "tax", "taxRate", "type",
        "createdAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetTradeHistoryItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetTradeHistoryItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "symbol": obj.get("symbol"),
            "tradeId": obj.get("tradeId"),
            "orderId": obj.get("orderId"),
            "counterOrderId": obj.get("counterOrderId"),
            "side": obj.get("side"),
            "liquidity": obj.get("liquidity"),
            "forceTaker": obj.get("forceTaker"),
            "price": obj.get("price"),
            "size": obj.get("size"),
            "funds": obj.get("funds"),
            "fee": obj.get("fee"),
            "feeRate": obj.get("feeRate"),
            "feeCurrency": obj.get("feeCurrency"),
            "stop": obj.get("stop"),
            "tradeType": obj.get("tradeType"),
            "tax": obj.get("tax"),
            "taxRate": obj.get("taxRate"),
            "type": obj.get("type"),
            "createdAt": obj.get("createdAt")
        })
        return _obj
