# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetMarginRiskLimitData(BaseModel):
    """
    GetMarginRiskLimitData

    Attributes:
        timestamp (int): Time stamp
        currency (str): CROSS MARGIN RESPONSES, Currency
        borrow_max_amount (str): CROSS MARGIN RESPONSES, Maximum personal borrow amount. If the platform has no borrowing amount, this value will still be displayed.
        buy_max_amount (str): CROSS MARGIN RESPONSES, Maximum buy amount
        hold_max_amount (str): CROSS MARGIN RESPONSES, Maximum holding amount
        borrow_coefficient (str): CROSS MARGIN RESPONSES, [Borrow Coefficient](https://www.kucoin.com/land/price-protect)
        margin_coefficient (str): CROSS MARGIN RESPONSES, [Margin Coefficient](https://www.kucoin.com/land/price-protect)
        precision (int): CROSS MARGIN RESPONSES, Currency precision. the minimum repayment amount of a single transaction should be >= currency precision, for example, the precision of ETH is 8, and the minimum repayment amount is 0.00000001
        borrow_min_amount (str): CROSS MARGIN RESPONSES, Minimum personal borrow amount
        borrow_min_unit (str): CROSS MARGIN RESPONSES, Minimum unit for borrowing, the borrowed amount must be an integer multiple of this value
        borrow_enabled (bool): CROSS MARGIN RESPONSES, Whether to support borrowing
        symbol (str): ISOLATED MARGIN RESPONSES, Symbol
        base_max_borrow_amount (str): ISOLATED MARGIN RESPONSES, Base maximum personal borrow amount. If the platform has no borrowing amount, this value will still be displayed.
        quote_max_borrow_amount (str): ISOLATED MARGIN RESPONSES, Quote maximum personal borrow amount. If the platform has no borrowing amount, this value will still be displayed.
        base_max_buy_amount (str): ISOLATED MARGIN RESPONSES, Base maximum buy amount 
        quote_max_buy_amount (str): ISOLATED MARGIN RESPONSES, Quote maximum buy amount
        base_max_hold_amount (str): ISOLATED MARGIN RESPONSES, Base maximum holding amount 
        quote_max_hold_amount (str): ISOLATED MARGIN RESPONSES, Quote maximum holding amount 
        base_precision (int): ISOLATED MARGIN RESPONSES, Base currency precision. the minimum repayment amount of a single transaction should be >= currency precision, for example, the precision of ETH is 8, and the minimum repayment amount is 0.00000001
        quote_precision (int): ISOLATED MARGIN RESPONSES, Quote currency precision. the minimum repayment amount of a single transaction should be >= currency precision, for example, the precision of ETH is 8, and the minimum repayment amount is 0.00000001 
        base_borrow_min_amount (str): ISOLATED MARGIN RESPONSES, Base minimum personal borrow amount 
        quote_borrow_min_amount (str): ISOLATED MARGIN RESPONSES, Quote minimum personal borrow amount
        base_borrow_min_unit (str): ISOLATED MARGIN RESPONSES, Base minimum unit for borrowing, the borrowed amount must be an integer multiple of this value
        quote_borrow_min_unit (str): ISOLATED MARGIN RESPONSES, Quote minimum unit for borrowing, the borrowed amount must be an integer multiple of this value
        base_borrow_enabled (bool): ISOLATED MARGIN RESPONSES, Base whether to support borrowing 
        quote_borrow_enabled (bool): ISOLATED MARGIN RESPONSES, Quote whether to support borrowing 
        base_borrow_coefficient (str): ISOLATED MARGIN RESPONSES, [Base Borrow Coefficient](https://www.kucoin.com/land/price-protect)
        quote_borrow_coefficient (str): ISOLATED MARGIN RESPONSES, [Quote Borrow Coefficient](https://www.kucoin.com/land/price-protect)
        base_margin_coefficient (str): ISOLATED MARGIN RESPONSES, [Base Margin Coefficient](https://www.kucoin.com/land/price-protect)
        quote_margin_coefficient (str): ISOLATED MARGIN RESPONSES, [Quote Margin Coefficient](https://www.kucoin.com/land/price-protect)
    """

    timestamp: Optional[int] = Field(default=None, description="Time stamp")
    currency: Optional[str] = Field(
        default=None, description="CROSS MARGIN RESPONSES, Currency")
    borrow_max_amount: Optional[str] = Field(
        default=None,
        description=
        "CROSS MARGIN RESPONSES, Maximum personal borrow amount. If the platform has no borrowing amount, this value will still be displayed.",
        alias="borrowMaxAmount")
    buy_max_amount: Optional[str] = Field(
        default=None,
        description="CROSS MARGIN RESPONSES, Maximum buy amount",
        alias="buyMaxAmount")
    hold_max_amount: Optional[str] = Field(
        default=None,
        description="CROSS MARGIN RESPONSES, Maximum holding amount",
        alias="holdMaxAmount")
    borrow_coefficient: Optional[str] = Field(
        default=None,
        description=
        "CROSS MARGIN RESPONSES, [Borrow Coefficient](https://www.kucoin.com/land/price-protect)",
        alias="borrowCoefficient")
    margin_coefficient: Optional[str] = Field(
        default=None,
        description=
        "CROSS MARGIN RESPONSES, [Margin Coefficient](https://www.kucoin.com/land/price-protect)",
        alias="marginCoefficient")
    precision: Optional[int] = Field(
        default=None,
        description=
        "CROSS MARGIN RESPONSES, Currency precision. the minimum repayment amount of a single transaction should be >= currency precision, for example, the precision of ETH is 8, and the minimum repayment amount is 0.00000001"
    )
    borrow_min_amount: Optional[str] = Field(
        default=None,
        description="CROSS MARGIN RESPONSES, Minimum personal borrow amount",
        alias="borrowMinAmount")
    borrow_min_unit: Optional[str] = Field(
        default=None,
        description=
        "CROSS MARGIN RESPONSES, Minimum unit for borrowing, the borrowed amount must be an integer multiple of this value",
        alias="borrowMinUnit")
    borrow_enabled: Optional[bool] = Field(
        default=None,
        description="CROSS MARGIN RESPONSES, Whether to support borrowing",
        alias="borrowEnabled")
    symbol: Optional[str] = Field(
        default=None, description="ISOLATED MARGIN RESPONSES, Symbol")
    base_max_borrow_amount: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Base maximum personal borrow amount. If the platform has no borrowing amount, this value will still be displayed.",
        alias="baseMaxBorrowAmount")
    quote_max_borrow_amount: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Quote maximum personal borrow amount. If the platform has no borrowing amount, this value will still be displayed.",
        alias="quoteMaxBorrowAmount")
    base_max_buy_amount: Optional[str] = Field(
        default=None,
        description="ISOLATED MARGIN RESPONSES, Base maximum buy amount ",
        alias="baseMaxBuyAmount")
    quote_max_buy_amount: Optional[str] = Field(
        default=None,
        description="ISOLATED MARGIN RESPONSES, Quote maximum buy amount",
        alias="quoteMaxBuyAmount")
    base_max_hold_amount: Optional[str] = Field(
        default=None,
        description="ISOLATED MARGIN RESPONSES, Base maximum holding amount ",
        alias="baseMaxHoldAmount")
    quote_max_hold_amount: Optional[str] = Field(
        default=None,
        description="ISOLATED MARGIN RESPONSES, Quote maximum holding amount ",
        alias="quoteMaxHoldAmount")
    base_precision: Optional[int] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Base currency precision. the minimum repayment amount of a single transaction should be >= currency precision, for example, the precision of ETH is 8, and the minimum repayment amount is 0.00000001",
        alias="basePrecision")
    quote_precision: Optional[int] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Quote currency precision. the minimum repayment amount of a single transaction should be >= currency precision, for example, the precision of ETH is 8, and the minimum repayment amount is 0.00000001 ",
        alias="quotePrecision")
    base_borrow_min_amount: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Base minimum personal borrow amount ",
        alias="baseBorrowMinAmount")
    quote_borrow_min_amount: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Quote minimum personal borrow amount",
        alias="quoteBorrowMinAmount")
    base_borrow_min_unit: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Base minimum unit for borrowing, the borrowed amount must be an integer multiple of this value",
        alias="baseBorrowMinUnit")
    quote_borrow_min_unit: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Quote minimum unit for borrowing, the borrowed amount must be an integer multiple of this value",
        alias="quoteBorrowMinUnit")
    base_borrow_enabled: Optional[bool] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Base whether to support borrowing ",
        alias="baseBorrowEnabled")
    quote_borrow_enabled: Optional[bool] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, Quote whether to support borrowing ",
        alias="quoteBorrowEnabled")
    base_borrow_coefficient: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, [Base Borrow Coefficient](https://www.kucoin.com/land/price-protect)",
        alias="baseBorrowCoefficient")
    quote_borrow_coefficient: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, [Quote Borrow Coefficient](https://www.kucoin.com/land/price-protect)",
        alias="quoteBorrowCoefficient")
    base_margin_coefficient: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, [Base Margin Coefficient](https://www.kucoin.com/land/price-protect)",
        alias="baseMarginCoefficient")
    quote_margin_coefficient: Optional[str] = Field(
        default=None,
        description=
        "ISOLATED MARGIN RESPONSES, [Quote Margin Coefficient](https://www.kucoin.com/land/price-protect)",
        alias="quoteMarginCoefficient")

    __properties: ClassVar[List[str]] = [
        "timestamp", "currency", "borrowMaxAmount", "buyMaxAmount",
        "holdMaxAmount", "borrowCoefficient", "marginCoefficient", "precision",
        "borrowMinAmount", "borrowMinUnit", "borrowEnabled", "symbol",
        "baseMaxBorrowAmount", "quoteMaxBorrowAmount", "baseMaxBuyAmount",
        "quoteMaxBuyAmount", "baseMaxHoldAmount", "quoteMaxHoldAmount",
        "basePrecision", "quotePrecision", "baseBorrowMinAmount",
        "quoteBorrowMinAmount", "baseBorrowMinUnit", "quoteBorrowMinUnit",
        "baseBorrowEnabled", "quoteBorrowEnabled", "baseBorrowCoefficient",
        "quoteBorrowCoefficient", "baseMarginCoefficient",
        "quoteMarginCoefficient"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetMarginRiskLimitData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetMarginRiskLimitData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timestamp":
            obj.get("timestamp"),
            "currency":
            obj.get("currency"),
            "borrowMaxAmount":
            obj.get("borrowMaxAmount"),
            "buyMaxAmount":
            obj.get("buyMaxAmount"),
            "holdMaxAmount":
            obj.get("holdMaxAmount"),
            "borrowCoefficient":
            obj.get("borrowCoefficient"),
            "marginCoefficient":
            obj.get("marginCoefficient"),
            "precision":
            obj.get("precision"),
            "borrowMinAmount":
            obj.get("borrowMinAmount"),
            "borrowMinUnit":
            obj.get("borrowMinUnit"),
            "borrowEnabled":
            obj.get("borrowEnabled"),
            "symbol":
            obj.get("symbol"),
            "baseMaxBorrowAmount":
            obj.get("baseMaxBorrowAmount"),
            "quoteMaxBorrowAmount":
            obj.get("quoteMaxBorrowAmount"),
            "baseMaxBuyAmount":
            obj.get("baseMaxBuyAmount"),
            "quoteMaxBuyAmount":
            obj.get("quoteMaxBuyAmount"),
            "baseMaxHoldAmount":
            obj.get("baseMaxHoldAmount"),
            "quoteMaxHoldAmount":
            obj.get("quoteMaxHoldAmount"),
            "basePrecision":
            obj.get("basePrecision"),
            "quotePrecision":
            obj.get("quotePrecision"),
            "baseBorrowMinAmount":
            obj.get("baseBorrowMinAmount"),
            "quoteBorrowMinAmount":
            obj.get("quoteBorrowMinAmount"),
            "baseBorrowMinUnit":
            obj.get("baseBorrowMinUnit"),
            "quoteBorrowMinUnit":
            obj.get("quoteBorrowMinUnit"),
            "baseBorrowEnabled":
            obj.get("baseBorrowEnabled"),
            "quoteBorrowEnabled":
            obj.get("quoteBorrowEnabled"),
            "baseBorrowCoefficient":
            obj.get("baseBorrowCoefficient"),
            "quoteBorrowCoefficient":
            obj.get("quoteBorrowCoefficient"),
            "baseMarginCoefficient":
            obj.get("baseMarginCoefficient"),
            "quoteMarginCoefficient":
            obj.get("quoteMarginCoefficient")
        })
        return _obj
