# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetMarginRiskLimitReq(BaseModel):
    """
    GetMarginRiskLimitReq

    Attributes:
        is_isolated (bool): true-isolated, false-cross
        currency (str): currency, This field is only required for cross margin
        symbol (str): symbol, This field is only required for isolated margin
    """

    is_isolated: Optional[bool] = Field(
        default=None,
        description="true-isolated, false-cross",
        alias="isIsolated")
    currency: Optional[str] = Field(
        default=None,
        description="currency, This field is only required for cross margin")
    symbol: Optional[str] = Field(
        default=None,
        description="symbol, This field is only required for isolated margin")

    __properties: ClassVar[List[str]] = ["isIsolated", "currency", "symbol"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetMarginRiskLimitReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetMarginRiskLimitReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isIsolated": obj.get("isIsolated"),
            "currency": obj.get("currency"),
            "symbol": obj.get("symbol")
        })
        return _obj


class GetMarginRiskLimitReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_is_isolated(self, value: bool) -> GetMarginRiskLimitReqBuilder:
        """
        true-isolated, false-cross
        """
        self.obj['isIsolated'] = value
        return self

    def set_currency(self, value: str) -> GetMarginRiskLimitReqBuilder:
        """
        currency, This field is only required for cross margin
        """
        self.obj['currency'] = value
        return self

    def set_symbol(self, value: str) -> GetMarginRiskLimitReqBuilder:
        """
        symbol, This field is only required for isolated margin
        """
        self.obj['symbol'] = value
        return self

    def build(self) -> GetMarginRiskLimitReq:
        return GetMarginRiskLimitReq(**self.obj)
