# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from kucoin_universal_sdk.generate.account.account.api_account import AccountAPI, AccountAPIImpl
from kucoin_universal_sdk.generate.account.deposit.api_deposit import DepositAPI, DepositAPIImpl
from kucoin_universal_sdk.generate.account.fee.api_fee import FeeAPI, FeeAPIImpl
from kucoin_universal_sdk.generate.account.subaccount.api_sub_account import SubAccountAPI, SubAccountAPIImpl
from kucoin_universal_sdk.generate.account.transfer.api_transfer import TransferAPI, TransferAPIImpl
from kucoin_universal_sdk.generate.account.withdrawal.api_withdrawal import WithdrawalAPI, WithdrawalAPIImpl


class AccountService(ABC):

    @abstractmethod
    def get_account_api(self) -> AccountAPI:
        """
        get AccountAPI
        """
        pass

    @abstractmethod
    def get_deposit_api(self) -> DepositAPI:
        """
        get DepositAPI
        """
        pass

    @abstractmethod
    def get_withdrawal_api(self) -> WithdrawalAPI:
        """
        get WithdrawalAPI
        """
        pass

    @abstractmethod
    def get_fee_api(self) -> FeeAPI:
        """
        get FeeAPI
        """
        pass

    @abstractmethod
    def get_sub_account_api(self) -> SubAccountAPI:
        """
        get SubAccountAPI
        """
        pass

    @abstractmethod
    def get_transfer_api(self) -> TransferAPI:
        """
        get TransferAPI
        """
        pass


class AccountServiceImpl(AccountService):

    def __init__(self, transport: Transport):
        self.transport = transport
        self.account = AccountAPIImpl(transport)
        self.deposit = DepositAPIImpl(transport)
        self.withdrawal = WithdrawalAPIImpl(transport)
        self.fee = FeeAPIImpl(transport)
        self.sub_account = SubAccountAPIImpl(transport)
        self.transfer = TransferAPIImpl(transport)

    def get_account_api(self) -> AccountAPI:
        return self.account

    def get_deposit_api(self) -> DepositAPI:
        return self.deposit

    def get_withdrawal_api(self) -> WithdrawalAPI:
        return self.withdrawal

    def get_fee_api(self) -> FeeAPI:
        return self.fee

    def get_sub_account_api(self) -> SubAccountAPI:
        return self.sub_account

    def get_transfer_api(self) -> TransferAPI:
        return self.transfer
