# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from kucoin_universal_sdk.generate.futures.fundingfees.api_funding_fees import FundingFeesAPI, FundingFeesAPIImpl
from kucoin_universal_sdk.generate.futures.market.api_market import MarketAPI, MarketAPIImpl
from kucoin_universal_sdk.generate.futures.order.api_order import OrderAPI, OrderAPIImpl
from kucoin_universal_sdk.generate.futures.positions.api_positions import PositionsAPI, PositionsAPIImpl


class FuturesService(ABC):

    @abstractmethod
    def get_order_api(self) -> OrderAPI:
        """
        get OrderAPI
        """
        pass

    @abstractmethod
    def get_positions_api(self) -> PositionsAPI:
        """
        get PositionsAPI
        """
        pass

    @abstractmethod
    def get_funding_fees_api(self) -> FundingFeesAPI:
        """
        get FundingFeesAPI
        """
        pass

    @abstractmethod
    def get_market_api(self) -> MarketAPI:
        """
        get MarketAPI
        """
        pass


class FuturesServiceImpl(FuturesService):

    def __init__(self, transport: Transport):
        self.transport = transport
        self.order = OrderAPIImpl(transport)
        self.positions = PositionsAPIImpl(transport)
        self.funding_fees = FundingFeesAPIImpl(transport)
        self.market = MarketAPIImpl(transport)

    def get_order_api(self) -> OrderAPI:
        return self.order

    def get_positions_api(self) -> PositionsAPI:
        return self.positions

    def get_funding_fees_api(self) -> FundingFeesAPI:
        return self.funding_fees

    def get_market_api(self) -> MarketAPI:
        return self.market
