# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from kucoin_universal_sdk.generate.margin.credit.api_credit import CreditAPI, CreditAPIImpl
from kucoin_universal_sdk.generate.margin.debit.api_debit import DebitAPI, DebitAPIImpl
from kucoin_universal_sdk.generate.margin.market.api_market import MarketAPI, MarketAPIImpl
from kucoin_universal_sdk.generate.margin.order.api_order import OrderAPI, OrderAPIImpl
from kucoin_universal_sdk.generate.margin.risklimit.api_risk_limit import RiskLimitAPI, RiskLimitAPIImpl


class MarginService(ABC):

    @abstractmethod
    def get_order_api(self) -> OrderAPI:
        """
        get OrderAPI
        """
        pass

    @abstractmethod
    def get_debit_api(self) -> DebitAPI:
        """
        get DebitAPI
        """
        pass

    @abstractmethod
    def get_credit_api(self) -> CreditAPI:
        """
        get CreditAPI
        """
        pass

    @abstractmethod
    def get_market_api(self) -> MarketAPI:
        """
        get MarketAPI
        """
        pass

    @abstractmethod
    def get_risk_limit_api(self) -> RiskLimitAPI:
        """
        get RiskLimitAPI
        """
        pass


class MarginServiceImpl(MarginService):

    def __init__(self, transport: Transport):
        self.transport = transport
        self.order = OrderAPIImpl(transport)
        self.debit = DebitAPIImpl(transport)
        self.credit = CreditAPIImpl(transport)
        self.market = MarketAPIImpl(transport)
        self.risk_limit = RiskLimitAPIImpl(transport)

    def get_order_api(self) -> OrderAPI:
        return self.order

    def get_debit_api(self) -> DebitAPI:
        return self.debit

    def get_credit_api(self) -> CreditAPI:
        return self.credit

    def get_market_api(self) -> MarketAPI:
        return self.market

    def get_risk_limit_api(self) -> RiskLimitAPI:
        return self.risk_limit
